/**
 * Project Name:media-biz<br>
 * File Name:AccountDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年9月24日下午2:36:07<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;

/**
 * ClassName: AccountDAO <br/>
 * Function: 用户. <br/>
 * date: 2016年9月24日 下午2:36:07 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface AccountDAO {

    /**
     * 通过媒体账户ID查询媒体账户信息.
     *
     * @param id 媒体账户ID
     * @return 媒体账户信息
     * @throws TuiaMediaException 失败抛出异常
     */
    AccountDto selectById(Long mediaId) throws TuiaMediaException;

    /**
     * 通过邮箱名称查询用户账户信息.
     *
     * @param email 邮箱名称
     * @return 用户信息
     * @throws TuiaCoreException 失败抛出异常
     */
    AccountDto selectByEmail(String email) throws TuiaMediaException;

    /**
     * 通过手机好查询账户信息.
     *
     * @param phone the phone
     * @return the account dto
     * @throws TuiaMediaException the tuia media exception
     */
    AccountDto selectByPhone(String phone) throws TuiaMediaException;

    /**
     * 邮箱审核.
     *
     * @param id 账号ID
     * @param status 邮箱审核状态
     * @return the int
     * @throws TuiaCoreException 失败抛出异常
     */
    int updateEmailStatus(Long id, Integer status) throws TuiaMediaException;

    /**
     * 修改密码.<br>
     * 新密码不能和旧密码一致<br>
     *
     * @param email the email
     * @param password 新密码
     * @return the int
     * @throws TuiaCoreException 失败抛出异常
     */
    int updatePasswdByEmail(String email, String password) throws TuiaMediaException;

    /**
     * 新增媒体用户基本信息.
     *
     * @param t 带插入的记录
     * @return the int
     * @throws TuiaMediaException the tuia exception
     */
    int insert(AccountDto accountDto) throws TuiaMediaException;

    /**
     * 更新媒体账户信息.
     *
     * @throws TuiaMediaException the tuia media exception
     */
    int updateAccount(ReqUpdateAccountBase req) throws TuiaMediaException;

    /**
     * 重新提交媒体账户审核信息.
     *
     * @param req the req
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int updateAuditData(AccountDto req) throws TuiaMediaException;

    /**
     * 查询媒体账号总数.
     *
     * @param req the req
     * @return the integer
     * @throws TuiaMediaException the media manager exception
     */
    Integer selectMediaDataAmount(ReqGetAccountByPageDto req) throws TuiaMediaException;

    /**
     * 分页查询媒体账号列表.
     *
     * @param req the req
     * @return the list< media dto>
     * @throws TuiaMediaException the media manager exception
     */
    List<AccountDto> selectMediaDataByPage(ReqGetAccountByPageDto req) throws TuiaMediaException;

    /**
     * 审核媒体账户.
     *
     * @param mediaId the media id
     * @param status the status
     * @return the int
     * @throws TuiaMediaException the media manager exception
     */
    int updateCheckStatus(Long mediaId, Integer status) throws TuiaMediaException;

    /**
     * 冻结媒体账户.
     *
     * @param mediaId the media id
     * @param status the status
     * @return the int
     * @throws TuiaMediaException the media manager exception
     */
    int updateFreezeStatus(Long mediaId, Integer status) throws TuiaMediaException;

    /**
     * 更换邮箱.
     *
     * @param mediaId the media id
     * @param email the email
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int updateEmail(Long mediaId, String email) throws TuiaMediaException;

    /**
     * 通过媒体用户Id的集合查询邮箱地址
     * 
     * @author guyan
     * @param mediaIds
     * @return
     * @throws TuiaMediaException
     */
    List<IdAndName> selectMediaIdAndEmails(List<Long> mediaIds) throws TuiaMediaException;

}
