/**
 * Project Name:media-biz File Name:MediaAppConfigDao.java Package Name:cn.com.duiba.tuia.media.dao
 * Date:2016年10月8日下午7:47:10 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppConfigDto;

/**
 * ClassName:MediaAppConfigDao <br/>
 * Function: 媒体配置信息. <br/>
 * Date: 2016年10月8日 下午7:47:10 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface MediaAppConfigDao {

    /**
     * 创建媒体配置信息
     * 
     * @param param
     * @throws TuiaMediaException
     */
    int insert(MediaAppConfigDto param) throws TuiaMediaException;

    /**
     * 获取媒体配置信息列表
     * 
     * @param mediaAppQuery
     * @return
     * @throws TuiaMediaException
     */
    List<MediaAppDto> selectMediaAppConfigList(ReqGetMediaAppConfigByPageDto param) throws TuiaMediaException;

    /**
     * 修改媒体配置信息
     * 
     * @param mediaAppDto
     * @throws TuiaMediaException
     */
    int update(ReqUpdateMediaAppConfigDto param) throws TuiaMediaException;

    /**
     * 查询媒体配置信息
     * 
     * @param appId
     * @return
     * @throws TuiaMediaException
     */
    MediaAppConfigDto selectMediaAppConfigById(Long appId) throws TuiaMediaException;

    /**
     * 查询总数
     * 
     * @param param
     * @return
     * @throws TuiaMediaException
     */
    int selectAmountByPageQuery(ReqGetMediaAppConfigByPageDto param) throws TuiaMediaException;

}
