/**
 * Project Name:media-biz<br>
 * File Name:AccountBankDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年9月27日下午2:22:57<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;

import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountBankDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;

/**
 * ClassName: AccountBankDAOImpl <br/>
 * date: 2016年9月27日 下午2:22:57 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Service("accountBankDAO")
public class AccountBankDAOImpl extends BaseDAO implements AccountBankDAO {

    @Override
    public AccountBankDto selectById(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectById"), mediaId);
        } catch (Exception e) {
            logger.error("AccountCheckRecordDao.selectLatelyCheckRecord happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ReqUpdateAccountBank req) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), req);
        } catch (Exception e) {
            logger.error("AccountCheckRecordDao.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int insert(AccountBankDto accountBankDto) throws TuiaMediaException {
        try {
            accountBankDto.setGmtCreate(new Date());
            accountBankDto.setGmtModified(accountBankDto.getGmtCreate());
            return getSqlSession().insert(getStamentNameSpace("insert"), accountBankDto);
        } catch (Exception e) {
            logger.error("AccountBankDAOImpl.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
