/**
 * Project Name:media-biz<br>
 * File Name:AccountCheckRecordDaoImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年9月26日下午3:31:50<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Repository;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountCheckRecordDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.AccountCheckRecordDto;

/**
 * ClassName: AccountCheckRecordDaoImpl <br/>
 * date: 2016年9月26日 下午3:31:50 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Repository("accountCheckRecordDao")
public class AccountCheckRecordDAOImpl extends BaseDAO implements AccountCheckRecordDAO {

    @Override
    public AccountCheckRecordDto selectLatelyCheckRecord(long mediaId, int checkType) throws TuiaMediaException {
        try {
            Map<String, Object> paramMap = new HashMap<>(2);
            paramMap.put("mediaId", mediaId);
            paramMap.put("checkType", checkType);
            return getSqlSession().selectOne(getStamentNameSpace("selectLatelyCheckRecord"), paramMap);
        } catch (Exception e) {
            logger.error("AccountCheckRecordDAO.selectLatelyCheckRecord happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int insertCheckRecord(AccountCheckRecordDto dto) throws TuiaMediaException {
        try {
            dto.setGmtCreate(new Date());
            dto.setGmtModified(dto.getGmtCreate());
            return getSqlSession().insert(getStamentNameSpace("insertCheckRecord"), dto);
        } catch (Exception e) {
            logger.error("AccountCheckRecordDAO.insertCheckRecord data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
