/**
 * Project Name:media-biz File Name:MediaDaoImpl.java Package Name:cn.com.duiba.tuia.media.dao.impl
 * Date:2016年9月26日上午11:31:28 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;

/**
 * ClassName:MediaAppDaoImpl <br/>
 * Function: 媒体管理. <br/>
 * Date: 2016年9月26日 上午11:31:28 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("mediaAppDao")
public class MediaAppDaoImpl extends BaseDAO implements MediaAppDao {

    @Override
    public int insert(MediaAppDto param) throws TuiaMediaException {
        try {
            param.setGmtCreate(new Date());
            param.setGmtModified(param.getGmtCreate());
            return getSqlSession().insert(getStamentNameSpace("insert"), param);
        } catch (Exception e) {
            logger.error("MediaAppDaoImpl.createMediaApp happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MediaAppDto> selectMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectMediaAppList"), mediaAppQuery);
        } catch (Exception e) {
            logger.error("MediaAppDaoImpl.getMediaAppList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ReqUpdateMediaApp param) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), param);
        } catch (Exception e) {
            logger.error("MediaAppDaoImpl.updateMediaApp happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public MediaAppDto selectMediaAppById(Long appId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectMediaAppById"), appId);
        } catch (Exception e) {
            logger.error("MediaAppDaoImpl.selectMediaAppById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }

    }

    @Override
    public int selectAmountByPageQuery(ReqPageQueryMediaApp param) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAmountByPageQuery"), param);
        } catch (Exception e) {
            logger.error("MediaAppDaoImpl.selectAmountByPageQuery happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }

    }

    @SuppressWarnings("unchecked")
    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> ids) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return ListUtils.EMPTY_LIST;
            }

            return getSqlSession().selectList(getStamentNameSpace("selectAppIdAndName"), ids);
        } catch (Exception e) {
            logger.error("MediaAppDaoImpl.selectAppIdAndName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("updateMediaAppStatus"), param);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.updateCheckStatus happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectIdsByName(String appName) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectIdsByName"), appName);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.selectIdsByName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public MediaAppDto getMediaAppByName(String appName) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("getMediaAppByName"), appName);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.isMediaAppExists happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);

        }

    }

    @Override
    public MediaAppDto selectByAppKey(String appKey) throws TuiaMediaException {
        try {
            if (StringUtils.isEmpty(appKey)) {
                return null;
            }
            Map<String, Object> param = new HashMap<>(1);
            param.put("appkey", appKey);
            return getSqlSession().selectOne(getStamentNameSpace("selectByAppKey"), param);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.selectByAppKey happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<IdAndName> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectAppIdAndNameByMediaId"), mediaId);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.selectAppIdAndNameByMediaId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }

    }

}
