/**
 * Project Name:media-biz<br>
 * File Name:ShieldStrategyDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年9月26日下午7:43:09<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.ShieldStrategyDAO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.req.ReqShieldStrategy;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;

/**
 * ClassName: ShieldStrategyDAOImpl <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年9月26日 下午7:43:09 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Repository
public class ShieldStrategyDAOImpl extends BaseDAO implements ShieldStrategyDAO {

    @Override
    public int insert(ReqShieldStrategy strategyDto) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insert"), strategyDto);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ReqShieldStrategy strategyDto) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), strategyDto);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long id) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("delete"), id);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ShieldStrategyDto> selectListByMediaId(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListByMediaId"), mediaId);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.selectListByMediaId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public ShieldStrategyDto selectById(Long id) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectById"), id);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.selectById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ShieldStrategyDto> selectListByPage(ReqStrategyPageQuery req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectListByPage"), req);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.selectListByPage happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectAmountByPage(ReqStrategyPageQuery req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAmountByPage"), req);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.selectAmountByPage happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public boolean isNotExist(Long id, Long mediaId, String name) throws TuiaMediaException {

        Long strategyId = null;
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("mediaId", mediaId);
            param.put("strategyName", name);
            strategyId = getSqlSession().selectOne(getStamentNameSpace("selectIdByName"), param);
        } catch (Exception e) {
            logger.error("ShieldStrategyDAO.selectIdByName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }

        if (strategyId != null && (id == null || strategyId != id.longValue())) {
            throw new TuiaMediaException(ErrorCode.E0304003);
        }
        return true;
    }

}
