/**
 * Project Name:media-biz<br>
 * File Name:ReqActivityDataDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年10月18日下午2:00:06<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.req;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.api.dto.BaseDateQueryDto;

/**
 * ClassName: ReqActivityDataDto <br/>
 * Function: 分页查询活动数据请求参数. <br/>
 * date: 2016年10月18日 下午2:00:06 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ReqActivityData extends BaseDateQueryDto {

    private static final long serialVersionUID = 1L;

    /** 活动类型. */
    private Integer           duibaActivityType;

    /** 活动ID. */
    private Long              duibaActivityId;

    public ReqActivityData() {
        super();
    }

    public ReqActivityData(Integer duibaActivityType, Long duibaActivityId, Date startTime, Date endTime) {
        super(startTime, endTime);
        this.duibaActivityType = duibaActivityType;
        this.duibaActivityId = duibaActivityId;
    }

    public Integer getDuibaActivityType() {
        return duibaActivityType;
    }

    public void setDuibaActivityType(Integer duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
