/**
 * Project Name:media-biz<br/>
 * File Name:ReqAdsenseList.java<br/>
 * Package Name:cn.com.duiba.tuia.media.model.req<br/>
 * Date:2016年9月28日下午3:45:39<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位列表请求参数 <br/>
 * Date: 2016年9月28日 下午3:45:39 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqEditSlotEnableStatus implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 8447127897045201920L;

    @ApiModelProperty(value = "广告位Id", required = true)
    private Long              slotId;

    @ApiModelProperty(value = "广告位开启关闭状态:0-关闭;1-开启", required = true)
    private Boolean           enableStatus;

    @ApiModelProperty(value = "媒体账号ID", required = false)
    private Long              mediaId;

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Boolean getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Boolean enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
