/**
 * Project Name:media-biz<br>
 * File Name:ReqSendRegisterSMS.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月26日下午3:38:17<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.model.Captcha;

/**
 * ClassName: ReqSendRegisterSMS <br/>
 * Function: 发送注册短信验证码请求参数. <br/>
 * date: 2016年9月26日 下午3:38:17 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ReqSendSMS extends Captcha {

    /** 验证码类型. */
    @ApiModelProperty(value = "验证码类型", required = true)
    @NotNull(message = "验证码类型不能为空")
    private Integer type;

    /** 手机号. */
    @ApiModelProperty(value = "手机号", required = true)
    @NotNull(message = "手机号不能为空")
    private String  linkPhone;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * linkPhone.
     *
     * @return the linkPhone
     * @since JDK 1.6
     */
    public String getLinkPhone() {
        return linkPhone;
    }

    /**
     * linkPhone.
     *
     * @param linkPhone the linkPhone to set
     * @since JDK 1.6
     */
    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
