/**
 * Project Name:media-biz<br>
 * File Name:ReqUpdateAuditData.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月30日上午11:15:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

/**
 * ClassName: ReqUpdateAuditData <br/>
 * date: 2016年9月30日 上午11:15:19 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqUpdateAuditData {

    /** The media id. */
    @NotNull(message = "媒体账户ID不可为空")
    private Long    mediaId;

    /** 公司名称. */
    @ApiModelProperty(value = "公司名称", required = true)
    @NotBlank(message = "公司名称不可为空")
    private String  companyName;

    /** 营业执照号. */
    @ApiModelProperty(value = "营业执照号", required = true)
    @NotBlank(message = "营业执照号不可为空")
    private String  businessLicenseId;

    /** 营业执照文件名. */
    @ApiModelProperty(value = "营业执照文件名", required = true)
    @NotBlank(message = "营业执照文件名不可为空")
    private String  businessLicenseName;

    /** 营业执照文件地址. */
    @ApiModelProperty(value = "营业执照文件地址", required = true)
    @NotBlank(message = "营业执照文件地址不可为空")
    private String  businessLicenseUrl;

    /** 联系人姓名. */
    @ApiModelProperty(value = "联系人姓名", required = true)
    @NotBlank(message = "联系人姓名不可为空")
    private String  linkman;

    /** 联系人手机号. */
    @ApiModelProperty(value = "联系人手机号", required = true)
    @NotBlank(message = "联系人手机号不可为空")
    private String  linkPhone;

    /** 银行卡号. */
    @ApiModelProperty(value = "银行卡号", required = true)
    @NotBlank(message = "银行卡号不可为空")
    private String  cardNumber;

    /** 开户银行名称. */
    @ApiModelProperty(value = "开户银行名称", required = true)
    @NotBlank(message = "开户银行名称不可为空")
    private String  bankName;

    /** 开户银行所在省编码. */
    @ApiModelProperty(value = "开户银行所在省编码", required = true)
    @NotBlank(message = "开户银行所在省不可为空")
    private String  province;

    /** 开户银行所在市编码. */
    @ApiModelProperty(value = "开户银行所在市编码", required = true)
    @NotBlank(message = "开户银行所在市不可为空")
    private String  city;

    /** 支行名称. */
    @ApiModelProperty(value = "支行名称", required = true)
    @NotBlank(message = "支行名称不可为空")
    private String  branchName;

    /** 验证码类型. */
    @ApiModelProperty(value = "验证码类型", required = false)
    @NotNull(message = "验证码类型不能为空")
    private Integer type;

    /** 验证码. */
    @ApiModelProperty(value = "验证码", required = false)
    @NotNull(message = "验证码不能为空")
    private String  code;

    /**
     * type.
     *
     * @return the type
     * @since JDK 1.6
     */
    public Integer getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     * @since JDK 1.6
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * code.
     *
     * @return the code
     * @since JDK 1.6
     */
    public String getCode() {
        return code;
    }

    /**
     * code.
     *
     * @param code the code to set
     * @since JDK 1.6
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * companyName.
     *
     * @return the companyName
     * @since JDK 1.6
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * companyName.
     *
     * @param companyName the companyName to set
     * @since JDK 1.6
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * businessLicenseId.
     *
     * @return the businessLicenseId
     * @since JDK 1.6
     */
    public String getBusinessLicenseId() {
        return businessLicenseId;
    }

    /**
     * businessLicenseId.
     *
     * @param businessLicenseId the businessLicenseId to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseId(String businessLicenseId) {
        this.businessLicenseId = businessLicenseId;
    }

    /**
     * businessLicenseName.
     *
     * @return the businessLicenseName
     * @since JDK 1.6
     */
    public String getBusinessLicenseName() {
        return businessLicenseName;
    }

    /**
     * businessLicenseName.
     *
     * @param businessLicenseName the businessLicenseName to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseName(String businessLicenseName) {
        this.businessLicenseName = businessLicenseName;
    }

    /**
     * businessLicenseUrl.
     *
     * @return the businessLicenseUrl
     * @since JDK 1.6
     */
    public String getBusinessLicenseUrl() {
        return businessLicenseUrl;
    }

    /**
     * businessLicenseUrl.
     *
     * @param businessLicenseUrl the businessLicenseUrl to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseUrl(String businessLicenseUrl) {
        this.businessLicenseUrl = businessLicenseUrl;
    }

    /**
     * linkman.
     *
     * @return the linkman
     * @since JDK 1.6
     */
    public String getLinkman() {
        return linkman;
    }

    /**
     * linkman.
     *
     * @param linkman the linkman to set
     * @since JDK 1.6
     */
    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    /**
     * linkPhone.
     *
     * @return the linkPhone
     * @since JDK 1.6
     */
    public String getLinkPhone() {
        return linkPhone;
    }

    /**
     * linkPhone.
     *
     * @param linkPhone the linkPhone to set
     * @since JDK 1.6
     */
    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    /**
     * cardNumber.
     *
     * @return the cardNumber
     * @since JDK 1.6
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /**
     * cardNumber.
     *
     * @param cardNumber the cardNumber to set
     * @since JDK 1.6
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /**
     * bankName.
     *
     * @return the bankName
     * @since JDK 1.6
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * bankName.
     *
     * @param bankName the bankName to set
     * @since JDK 1.6
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    /**
     * province.
     *
     * @return the province
     * @since JDK 1.6
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     * @since JDK 1.6
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     * @since JDK 1.6
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     * @since JDK 1.6
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * branchName.
     *
     * @return the branchName
     * @since JDK 1.6
     */
    public String getBranchName() {
        return branchName;
    }

    /**
     * branchName.
     *
     * @param branchName the branchName to set
     * @since JDK 1.6
     */
    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
