/**
 * Project Name:media-biz<br>
 * File Name:StrategyPageResult.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.rsp<br>
 * Date:2016年9月27日上午11:47:03<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.rsp;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

/**
 * ClassName: StrategyPageResult <br/>
 * Function: 屏蔽策略基本信息. <br/>
 * date: 2016年9月27日 上午11:47:03 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class BaseStrategy {

    /** 主键ID. */
    private Long   id;

    /** 屏蔽策略名称. */
    @NotNull(message = "屏蔽策略名称不能为空")
    @Length(max = 10, min = 2, message = "屏蔽策略名称在2到10个字符之间")
    @ApiModelProperty(value = "屏蔽策略名称", required = true)
    private String strategyName;

    public BaseStrategy() {
        super();
    }

    public BaseStrategy(Long id, String name) {
        super();
        this.id = id;
        this.strategyName = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
