/**
 * Project Name:media-biz<br/>
 * File Name:ReqAdsenseList.java<br/>
 * Package Name:cn.com.duiba.tuia.media.model.req<br/>
 * Date:2016年9月28日下午3:45:39<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.model.rsp;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位列表请求参数 <br/>
 * Date: 2016年9月28日 下午3:45:39 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlot implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -7547539198840224448L;

    /** 广告位ID. */
    private Long              slotId;

    /** 广告位名称. */
    private String            slotName;

    /** appId. */
    private Long              appId;

    /** app名称. */
    private String            appName;

    /** 广告位类型. */
    private Integer           slotType;

    /** 审核状态. */
    private Integer           checkStatus;

    /** 广告位状态. */
    private Integer           enableStatus;

    /** 修改日期（String 类型）. */
    private String            modifiedDate;

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * enableStatus.
     *
     * @return the enableStatus
     * @since JDK 1.6
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * enableStatus.
     *
     * @param enableStatus the enableStatus to set
     * @since JDK 1.6
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    /**
     * modifiedDate.
     *
     * @return the modifiedDate
     * @since JDK 1.6
     */
    public String getModifiedDate() {
        return modifiedDate;
    }

    /**
     * modifiedDate.
     *
     * @param modifiedDate the modifiedDate to set
     * @since JDK 1.6
     */
    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
