/**
 * Project Name:media-biz<br>
 * File Name:RemoteMediaServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.remoteservice<br>
 * Date:2016年9月29日下午2:30:53<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.remoteservice;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.StrategyDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteMediaServiceImpl <br/>
 * Function: 推啊媒体服务. <br/>
 * date: 2016年9月29日 下午2:30:53 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RemoteMediaServiceImpl extends BaseRemoteService implements RemoteMediaService {

    @Autowired
    private MediaCacheService mediaCacheService;

    @Autowired
    private SlotCacheService  slotCacheService;

    @Override
    public DubboResult<StrategyDto> getStrategy(long slotId) {
        try {
            return DubboResult.successResult(slotCacheService.getStrategy(slotId));
        } catch (Exception e) {
            logger.error("RemoteMediaService.getStrategy is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> isValidMediaApp(long mediaAppId) {
        try {
            return DubboResult.successResult(mediaCacheService.isValidMediaApp(mediaAppId));
        } catch (Exception e) {
            logger.error("RemoteMediaService.isValidMediaApp is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<MediaAppDataDto> getMediaApp(long mediaAppId) {
        try {
            return DubboResult.successResult(mediaCacheService.getMediaApp(mediaAppId));
        } catch (Exception e) {
            logger.error("RemoteMediaService.getMediaApp is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<SlotCacheDto> getSlot(long slotId) {
        try {
            return DubboResult.successResult(slotCacheService.getSlot(slotId));
        } catch (Exception e) {
            logger.error("RemoteMediaService.getSlot is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<StrategyDto> updateStrategy(long slotId) {
        try {
            return DubboResult.successResult(slotCacheService.updateStrategy(slotId));
        } catch (Exception e) {
            logger.error("RemoteMediaService.updateStrategy is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<MediaAppDataDto> getMediaAppByKey(String appKey) {
        try {
            return DubboResult.successResult(mediaCacheService.getMediaAppByKey(appKey));
        } catch (Exception e) {
            logger.error("RemoteMediaService.getMediaAppByKey is error");
            return exceptionFailure(e);
        }
    }

}
