/**
 * Project Name:media-biz<br>
 * File Name:StatisticsService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年10月10日下午4:31:50<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service;

import java.util.List;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;

/**
 * ClassName: StatisticsService <br/>
 * date: 2016年10月10日 下午4:31:50 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface SlotStatisticsService {

    /**
     * 分页统计广告位数据总数.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @param appIdsByName the app ids by name
     * @return the adsense data amount
     * @throws TuiaMediaException the tuia media exception
     */
    int getAdsenseDataAmount(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList)
                                                                                                     throws TuiaMediaException;

    /**
     * 分页统计广告位数据.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @param appIdsByName the app ids by name
     * @return the adsense data by page
     * @throws TuiaMediaException the tuia media exception
     */
    List<SlotStatisticsDto> getAdsenseDataByPage(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList) throws TuiaMediaException;

    /**
     * 分页统计媒体应用数据总数.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @return the media data amount
     * @throws TuiaMediaException the tuia media exception
     */
    int getMediaDataAmount(ReqMediaAppStatisticsDto req, List<Long> appIdsByName) throws TuiaMediaException;

    /**
     * 分页统计媒体应用数据.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @return the media data by page
     * @throws TuiaMediaException the tuia media exception
     */
    List<MediaAppStatisticsDto> getMediaDataByPage(ReqMediaAppStatisticsDto req, List<Long> appIdsByName)
                                                                                                         throws TuiaMediaException;
}
