/**
 * Project Name:media-biz<br>
 * File Name:SmsServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.service.impl<br>
 * Date:2016年9月26日下午2:03:02<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.service.impl;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.IDGeneratorTool;
import cn.com.duiba.tuia.media.model.req.ReqSendSMS;
import cn.com.duiba.tuia.media.service.SmsService;
import cn.com.duiba.tuia.media.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.utils.SmsUtils;
import cn.com.duiba.wolf.redis.RedisClient;

/**
 * ClassName: SmsServiceImpl <br/>
 * Function: 短信Service实现类. <br/>
 * date: 2016年9月26日 下午2:03:02 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Service
public class SmsServiceImpl implements SmsService {

    /** 10分钟. */
    private static final int TEN_MINUTES     = 600;

    /** 注册. */
    private static final int REGISTER        = 1;

    @Autowired
    private RedisClient      redisClient;

    /** 短信验证码位数. */
    private static final int SMS_CODE_LENGTH = 6;

    @Override
    public Boolean send(ReqSendSMS req) throws TuiaMediaException {
        // 1. 极验校验
        //JiYanTool.authJiYanCode(req);
        // 2. 生成验证码
        String code = IDGeneratorTool.getRandomInt(SMS_CODE_LENGTH);
        // 3. 存入缓存
        redisClient.setex(CacheKeyUtils.getSmsKey(req.getLinkPhone(), req.getType()), TEN_MINUTES, code);

        // 4. 发送短信验证码
        String text;
        if (REGISTER == req.getType()) {
            text = "【兑吧科技】尊敬的用户，您的注册短信验证码为：" + code + "，10分钟内有效";
        } else {
            // 非法的验证码类型
            throw new TuiaMediaException(ErrorCode.E0001009);
        }
        SmsUtils.sendCodeSms(req.getLinkPhone(), text);

        return true;
    }

    @Override
    public Boolean verify(int type, String phone, String code) throws TuiaMediaException {
        String cacheCode = redisClient.get(CacheKeyUtils.getSmsKey(phone, type));
        if (StringUtils.equals(code, cacheCode)) {
            redisClient.del(CacheKeyUtils.getSmsKey(phone, type));
            return true;
        }
        throw new TuiaMediaException(ErrorCode.E0001010);
    }
}
