package cn.com.duiba.tuia.media.utils;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import cn.com.duiba.tuia.media.utils.RequestLocal;

public class CookieUtil {

    /**
     * @param name
     * @param wildcard *.duiba.com.cn 级别，还是完整域名级别
     * @return
     */
    public static Cookie createCookie(String name, String value, boolean wildcard) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (wildcard) {
            // switch(Environment.getCurrentEnvironment()){
            // case PRODUCTION:
            // cookie.setDomain(".duiba.com.cn");
            // }
        }

        return cookie;
    }

    /**
     * 设置通配符级别的cookie
     * 
     * @param name
     */
    public static void setWildcardCookie(String name, String value) {
        setCookie(name, value);
    }

    public static void setCookie(String name, String value) {
        Cookie cookie = createCookie(name, value, false);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    /**
     * 如果是线上环境，对应到.duiba.com.cn；如果是测试环境或者预发环境，通过配置项读取
     * 
     * @param name
     * @param value
     * @return
     */
    public static Cookie createCrossCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        // cookie.setDomain(TuiaDomainConstant.tuia_domain_name);
        return cookie;
    }

    public static void setCrossCookie(String name, String value) {
        Cookie cookie = createCrossCookie(name, value);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    /**
     * 删除通配符级别的cookie
     * 
     * @param name
     */
    public static void deleteWildcardCookie(String name) {
        Cookie cookie = createCookie(name, null, true);
        cookie.setMaxAge(0);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    public static void deleteCookie(String name) {
        Cookie cookie = createCookie(name, null, false);
        cookie.setMaxAge(0);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    /**
     * 根据名字获取cookie
     * 
     * @param request
     * @param name
     * @return
     */
    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = ReadCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = (Cookie) cookieMap.get(name);
            return cookie;
        } else {
            return null;
        }
    }

    /**
     * 将cookie封装到Map里面
     * 
     * @param request
     * @return
     */
    private static Map<String, Cookie> ReadCookieMap(HttpServletRequest request) {
        Map<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    /**
     * 设置cookie
     * 
     * @param response
     * @param name cookie名字
     * @param value cookie值
     * @param maxAge cookie生命周期 以秒为单位
     */
    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxAge > 0) cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

}
