/**
 * Project Name:manager-common<br>
 * File Name:DataTool.java<br>
 * Package Name:cn.com.duiba.tuia.manager.tool<br>
 * Date:2016年6月28日上午11:25:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.utils;

import java.math.BigDecimal;

/**
 * ClassName: DataTool <br/>
 * Function: 数据工具类. <br/>
 * date: 2016年6月28日 上午11:25:24 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class DataTool {

    /**
     * 计算点击均价.
     *
     * @param divisor 分子
     * @param dividend 分母
     * @return the integer
     */
    public static Long division(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend.longValue() != 0 && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, BigDecimal.ROUND_HALF_UP).longValue();
        }
        return result;
    }

    /**
     * 计算比率(divisor/dividend).<br>
     * 保留2为小数<br>
     * 
     * @param divisor 分子
     * @param dividend 分母
     * @return the long
     */
    public static Float calculateRatio(Long divisor, Long dividend) {
        Float result = null;
        if (dividend != null && dividend.longValue() != 0 && divisor != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(divisor).divide(BigDecimal.valueOf(dividend),2,BigDecimal.ROUND_HALF_UP);
            return bigDecimal.floatValue();
        }
        return result;
    }

}
