/**
 * Project Name:media-biz<br>
 * File Name:MsgUtils.java<br>
 * Package Name:cn.com.duiba.tuia.media.utils<br>
 * Date:2016年9月26日下午1:51:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.utils;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: MsgUtils <br/>
 * Function: 发送短信验证码. <br/>
 * date: 2016年9月26日 下午1:51:11 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class SmsUtils {

    /** The logger. */
    private static Logger logger = LoggerFactory.getLogger(SmsUtils.class);

    public static String sendCodeSms(String phone, String text) throws TuiaMediaException {
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost("http://yunpian.com/v1/sms/send.json");
            List<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new BasicNameValuePair("mobile", phone));
            params.add(new BasicNameValuePair("text", text));
            params.add(new BasicNameValuePair("apikey", "dd66615d922f2519ff134c0df909e505"));
            post.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = client.execute(post);
            return EntityUtils.toString(response.getEntity());
        } catch (Exception e) {
            logger.error("send sms error, because of ", e);
            throw new TuiaMediaException(ErrorCode.E0002008);
        }
    }
}
