/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaAppBackendService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteMediaAppBackendServiceImpl
extends BaseRemoteService
implements RemoteMediaAppBackendService {
    @Autowired
    MediaAppService mediaAppService;

    public DubboResult<Boolean> updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.updateMediaAppStatus(param));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.updateMediaAppStatus is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<MediaAppDto> getMediaApp(Long appId) {
        try {
            return DubboResult.successResult((Object)this.mediaAppService.getMediaAppDto(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspMediaAppConfigDto>> getMediaAppByIds(List<Long> ids) {
        try {
            List<IdAndName> list = this.mediaAppService.selectAppIdAndName(ids);
            ArrayList<RspMediaAppConfigDto> result = new ArrayList<RspMediaAppConfigDto>();
            for (IdAndName idAndName : list) {
                RspMediaAppConfigDto rspMediaAppConfigDto = new RspMediaAppConfigDto();
                rspMediaAppConfigDto.setAppId(idAndName.getId());
                rspMediaAppConfigDto.setAppName(idAndName.getName());
                result.add(rspMediaAppConfigDto);
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

