/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountBaseDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaBackendService;
import cn.com.duiba.tuia.media.bo.AccountBackendBO;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteMediaBackendServiceImpl
extends BaseRemoteService
implements RemoteMediaBackendService {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountBackendBO accountBackendBO;

    public DubboResult<PageResultDto<RspAccountBaseDto>> getMediasByPage(ReqGetAccountByPageDto req) {
        try {
            return DubboResult.successResult(this.accountService.pageQuery(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaBackendService.getMediasByPage is error, the param={}", (Object)req);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<AccountDto> getMediaByMediaId(long mediaId) {
        try {
            return DubboResult.successResult((Object)this.accountService.selectByMediaId(mediaId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaBackendService.getMediaByMediaId error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateCheckStatus(long mediaId, int checkType, String reason) {
        try {
            return DubboResult.successResult((Object)this.accountBackendBO.updateCheckStatus(mediaId, checkType, reason));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaBackendService.updateCheckStatus error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateFreezeStatus(long mediaId, int checkType, String reason) {
        try {
            return DubboResult.successResult((Object)this.accountBackendBO.updateFreezeStatus(mediaId, checkType, reason));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaBackendService.updateFreezeStatus error");
            return this.exceptionFailure(e);
        }
    }
}

