/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAdvertDAO;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityAdvertDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityAdvertService")
public class ActivityAdvertServiceImpl
implements ActivityAdvertService {
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private ActivityAdvertDAO activityAdvertDAO;

    @Override
    public Boolean activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, List<Long> advertIds) throws TuiaMediaException {
        if (1 != directStatus && 0 != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDirectAdvert(directStatus);
        this.activityDAO.update(activityDto);
        this.activityAdvertDAO.delete(activityId, activityType);
        if (!CollectionUtils.isEmpty(advertIds)) {
            ArrayList<ActivityAdvertDO> list = new ArrayList<ActivityAdvertDO>(advertIds.size());
            for (Long advertId : advertIds) {
                ActivityAdvertDO activityAdvertDO = new ActivityAdvertDO();
                activityAdvertDO.setActivityId(activityId);
                activityAdvertDO.setActivityType(activityType);
                activityAdvertDO.setAdvertId(advertId);
                list.add(activityAdvertDO);
            }
            this.activityAdvertDAO.insertBatch(list);
        }
        return true;
    }
}

