/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityBackendService;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.MediaAppActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivityBackendServiceImpl
extends BaseRemoteService
implements RemoteActivityBackendService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private MediaAppActivityService mediaAppActivityService;
    @Autowired
    private ActivityAdvertService activityAdvertService;

    public DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds) {
        try {
            List<RspActivityDto> rspActivityDtoList = this.activityService.getActivityByIds(activityIds);
            return DubboResult.successResult(rspActivityDtoList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getByActivityIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<String> getActivityNameByIdAndType(Long id, Integer type) {
        try {
            String name = this.activityService.getActivityName(id, type);
            return DubboResult.successResult((Object)name);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityByIdAndType is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getPlanList(ReqActivityDto req) {
        try {
            return DubboResult.successResult(this.activityService.getPlanList(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getPlanList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities) {
        try {
            return DubboResult.successResult((Object)this.activityService.addActivityPlan(activities));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.addActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> deleteActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activityService.deleteActivityPlan(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.deleteActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) {
        try {
            return DubboResult.successResult((Object)this.activityService.changeActivityPlanEnable(activityId, activityType, enableStatus));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.changeActivityPlanEnable is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto) {
        try {
            return DubboResult.successResult((Object)this.activityService.updateActivityPlan(reqActivityDto));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.updateActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer activityType) {
        try {
            RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetail(activityId, activityType);
            rspActivityDto = this.activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult((Object)rspActivityDto);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityPlanDetail is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> appIds) {
        try {
            return DubboResult.successResult((Object)this.mediaAppActivityService.activityDirectToMediaApp(activityId, activityType, directStatus, directMode, appIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.activityDirectToMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, List<Long> advertIds) {
        try {
            return DubboResult.successResult((Object)this.activityAdvertService.activityDirectToAdvert(activityId, activityType, directStatus, advertIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.activityDirectToAdvert is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activityService.getActivityPlanDetail(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(this.activityAdvertService.getActivityAdvertIds(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityAdvertIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

