/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.tuia.media.api.dto.MediaAppCheckRecordDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreatMediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.dao.MediaAppCheckRecordDao;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspMediaApp;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.tuia.media.service.MediaAppConfigService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.Base58;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MediaAppServiceImpl
extends BaseService
implements MediaAppService {
    protected Logger log = LoggerFactory.getLogger(MediaAppServiceImpl.class);
    @Autowired
    private MediaAppDao mediaAppDao;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private MediaAppCheckRecordDao mediaAppCheckRecordDao;
    @Value(value="${media.consumer.encrypt.key}")
    private String consumerEncryptKey;
    @Autowired
    private MediaAppConfigService mediaAppConfigService;

    @Override
    public Boolean createMediaApp(ReqCreatMediaAppDto param) throws TuiaMediaException {
        CreateAppQueryParams createApp = new CreateAppQueryParams();
        Long mediaId = param.getMediaId();
        if (StringUtils.isEmpty((String)param.getAppName())) {
            throw new TuiaMediaException(ErrorCode.E0102001);
        }
        MediaAppDto mediaApp = this.mediaAppDao.getMediaAppByName(param.getAppName());
        if (null != mediaApp) {
            throw new TuiaMediaException(ErrorCode.E0401008);
        }
        createApp.setDeveloperId(mediaId);
        createApp.setName(param.getAppName());
        createApp.setMallCredits(Boolean.valueOf(true));
        createApp.setCreateSource(CreateAppQueryParams.CREATE_SOURCE_AD);
        MediaAppDto mediaAppDto = this.getMediaAppByRemote(createApp);
        mediaAppDto.setMediaId(mediaId);
        mediaAppDto.setAppName(param.getAppName());
        mediaAppDto.setPlatform(param.getPlatform());
        mediaAppDto.setIndustry(param.getIndustry());
        mediaAppDto.setCheckStatus(Integer.valueOf(0));
        mediaAppDto.setAppPackage(param.getAppPackage());
        mediaAppDto.setDescription(param.getDescription());
        mediaAppDto.setDownloadUrl(param.getDownloadUrl());
        mediaAppDto.setAppKeyWords(param.getAppKeyWords());
        this.mediaAppDao.insert(mediaAppDto);
        this.mediaCacheService.updateMediaAppCache(mediaAppDto.getAppId());
        ReqCreateMediaAppConfigDto dto = new ReqCreateMediaAppConfigDto();
        dto.setAppId(mediaAppDto.getAppId());
        dto.setChargeType(MediaAppConfigDto.CHARGE_TYPE_DIVIDED_INTO);
        dto.setPrice(Long.valueOf(0L));
        dto.setMediaSplitRatio(MediaAppConfigDto.MEDIA_SPLIT_RATIO_NUM);
        dto.setPlatformSplitRatio(MediaAppConfigDto.PLATFORM_SPLIT_RATIO_NUM);
        dto.setIsDeducted(MediaAppConfigDto.IS_DEDUCTED);
        dto.setDeductedPercent(MediaAppConfigDto.DEDUCTEDPERCENT_NUM);
        this.mediaAppConfigService.createMediaAppConfig(dto);
        return true;
    }

    @Override
    public PageResultDto<RspMediaApp> getMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException {
        mediaAppQuery.setPageSize(50);
        mediaAppQuery.setRowStart((mediaAppQuery.getCurrentPage() - 1) * mediaAppQuery.getPageSize());
        mediaAppQuery.setSort("gmt_create");
        mediaAppQuery.setOrder("desc");
        ArrayList<RspMediaApp> rspMediaAppList = null;
        int totalNum = this.mediaAppDao.selectAmountByPageQuery(mediaAppQuery);
        if (totalNum > 0 && totalNum >= mediaAppQuery.getRowStart()) {
            List<MediaAppDto> mediaAppList = this.mediaAppDao.selectMediaAppList(mediaAppQuery);
            if (CollectionUtils.isNotEmpty(mediaAppList)) {
                rspMediaAppList = new ArrayList<RspMediaApp>(mediaAppList.size());
                for (MediaAppDto dto : mediaAppList) {
                    RspMediaApp rspMediaApp = new RspMediaApp();
                    rspMediaApp.setAppId(dto.getAppId());
                    rspMediaApp.setAppKey(dto.getAppKey());
                    String appSecret = dto.getAppSecret();
                    rspMediaApp.setAppSecret(BlowfishUtils.decryptBlowfish((String)(StringUtils.isNotEmpty((String)dto.getAppSecret()) ? appSecret : ""), (String)this.consumerEncryptKey));
                    rspMediaApp.setAppSecret(dto.getAppSecret());
                    rspMediaApp.setMediaId(dto.getMediaId());
                    rspMediaApp.setAppName(dto.getAppName());
                    rspMediaApp.setIndustry(dto.getIndustry());
                    rspMediaApp.setCheckStatus(dto.getCheckStatus());
                    rspMediaApp.setPlatform(dto.getPlatform());
                    rspMediaApp.setCreateDate(new DateTime((Object)dto.getGmtCreate()).toString("yyyy-MM-dd"));
                    rspMediaAppList.add(rspMediaApp);
                }
            } else {
                rspMediaAppList = ListUtils.EMPTY_LIST;
            }
        }
        return new PageResultDto(totalNum, rspMediaAppList, mediaAppQuery.getPageSize().intValue());
    }

    @Override
    public Boolean updateMediaApp(ReqUpdateMediaApp param) throws TuiaMediaException {
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(param.getAppId());
        if (mediaAppDto == null) {
            this.logger.error("the mediaAppDto is not exist, the appId = [{}]", (Object)param.getAppId());
            throw new TuiaMediaException(ErrorCode.E0401001);
        }
        if (mediaAppDto.getCheckStatus() != null && mediaAppDto.getCheckStatus() == 2) {
            param.setCheckStatus(0);
            this.mediaAppDao.update(param);
        }
        if (mediaAppDto.getCheckStatus() != null && mediaAppDto.getCheckStatus() == 1) {
            param.setCheckStatus(0);
            this.mediaAppDao.update(param);
        }
        this.mediaCacheService.updateMediaAppCache(param.getAppId());
        return true;
    }

    @Override
    public MediaAppDto getMediaAppDto(Long appId) throws TuiaMediaException {
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(appId);
        if (mediaAppDto == null) {
            this.logger.error("the mediaAppDto is not exist, the appId = [{}]", (Object)appId);
            throw new TuiaMediaException(ErrorCode.E0401001);
        }
        return mediaAppDto;
    }

    @Override
    public Boolean updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException {
        int result = this.mediaAppDao.updateMediaAppStatus(param);
        if (result == 1 && (param.getCheckStatus() == 2 || param.getCheckStatus() == 1)) {
            MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(param.getAppId());
            MediaAppCheckRecordDto checkRecordDto = new MediaAppCheckRecordDto();
            checkRecordDto.setAppId(mediaAppDto.getAppId());
            checkRecordDto.setCheckType(mediaAppDto.getCheckStatus());
            checkRecordDto.setMediaId(mediaAppDto.getMediaId());
            this.mediaAppCheckRecordDao.insert(checkRecordDto);
        }
        this.mediaCacheService.updateMediaAppCache(param.getAppId());
        return true;
    }

    private MediaAppDto getMediaAppByRemote(CreateAppQueryParams param) throws TuiaMediaException {
        MediaAppDto mediaApp = new MediaAppDto();
        DubboResult appResult = this.remoteAppService.createApp(param);
        if (appResult == null || appResult.getResult() == null) {
            this.logger.error("the remoteAppService.createApp is error, the param = [{}]", (Object)param);
            throw new TuiaMediaException(ErrorCode.E0401003);
        }
        DubboResult dubboResult = this.remoteAppService.getSimpleApp((Long)appResult.getResult());
        if (dubboResult == null || dubboResult.getResult() == null) {
            throw new TuiaMediaException(ErrorCode.E0000001);
        }
        AppSimpleDto app = (AppSimpleDto)dubboResult.getResult();
        if (app.getAppKey() == null || app.getId() == null) {
            throw new TuiaMediaException(ErrorCode.E0401003);
        }
        mediaApp.setAppKey(app.getAppKey());
        mediaApp.setAppId(app.getId());
        mediaApp.setAppSecret(app.getAppSecret());
        String appSecret = this.generate();
        mediaApp.setAppSecret(BlowfishUtils.encryptBlowfish((String)(StringUtils.isNotEmpty((String)appSecret) ? appSecret : ""), (String)this.consumerEncryptKey));
        return mediaApp;
    }

    @Override
    public List<Long> selectIdsByName(String appName) throws TuiaMediaException {
        return this.mediaAppDao.selectIdsByName(appName);
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> appIds) throws TuiaMediaException {
        int size = appIds == null ? 0 : appIds.size();
        ArrayList<IdAndName> result = new ArrayList<IdAndName>(size);
        if (appIds != null) {
            int j = 0;
            for (int i = 1; i <= size; ++i) {
                if (i % 100 != 0 && i != size) continue;
                result.addAll(this.mediaAppDao.selectAppIdAndName(appIds.subList(j, i)));
                j = i;
            }
        }
        return result;
    }

    @Override
    public List<RspIdAndValue> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException {
        List<IdAndName> dtoList = this.mediaAppDao.selectAppIdAndNameByMediaId(mediaId);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            ArrayList<RspIdAndValue> rspList = new ArrayList<RspIdAndValue>(dtoList.size());
            for (IdAndName dto : dtoList) {
                RspIdAndValue rspDto = new RspIdAndValue();
                if (null != dto.getId()) {
                    rspDto.setId(Long.toString(dto.getId()));
                }
                rspDto.setValue(dto.getName());
                rspList.add(rspDto);
            }
            return rspList;
        }
        return ListUtils.EMPTY_LIST;
    }

    private String generate() {
        byte[] bs = SecurityUtils.encode2BytesBySHA((String)UUID.randomUUID().toString());
        return Base58.encode((byte[])bs);
    }
}

