/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.tuia.core.api.dto.TagDto;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteTagBackendService;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.TagLevel;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotBackendDetailDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.InformationStreamPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.constants.UserDefinedPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.StrategyService;
import cn.com.duiba.tuia.media.utils.StringTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotBackendBOImpl
extends BaseService
implements SlotBackendBo {
    @Autowired
    private SlotService soltService;
    @Autowired
    private StrategyService strategyService;
    @Autowired
    private MediaAppService mediaAppService;
    @Autowired
    private RemoteTagBackendService remoteTagBackendService;
    @Autowired
    private MaterialSpecificationService materialSpecificationService;

    @Override
    public Boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException {
        List<SlotDto> slotDtoList = this.soltService.getListDetail(slotIds);
        if (CollectionUtils.isNotEmpty(slotDtoList)) {
            for (SlotDto slotDto : slotDtoList) {
                if (1 != slotDto.getCheckStatus() && 2 != slotDto.getCheckStatus()) continue;
                this.logger.error("the slot is checked id = [{}]", (Object)slotDto.getId());
                throw new TuiaMediaException(ErrorCode.E0304007);
            }
        }
        return this.soltService.batchUpdateCheckStatus(slotIds, checkType);
    }

    @Override
    public RspSlotDetailDto getSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = this.soltService.selectById(slotId);
        Integer pictureSize = sltoDto.getPictureSize();
        RspSlotDetailDto rspSlotDetailDto = new RspSlotDetailDto();
        rspSlotDetailDto.setSlotId(sltoDto.getId());
        rspSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspSlotDetailDto.setAppId(sltoDto.getAppId());
        rspSlotDetailDto.setPictureSize(pictureSize);
        rspSlotDetailDto.setMsId(sltoDto.getSlotMsId());
        if (7 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setFlowType(UserDefinedPictureSizeEnmu.getFlowTypeBySizeId((int)pictureSize));
        }
        if (2 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setFlowType(InformationStreamPictureSizeEnmu.getFlowTypeBySizeId((int)pictureSize));
        }
        MediaAppDto mediaAppDto = this.mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        RspShieldStrategy rspShieldStrategy = this.strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspSlotDetailDto.setStrategyId(strategyId);
            rspSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspSlotDetailDto.setShieldIndustries(rspShieldStrategy.getShieldIndustries());
            rspSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }
        return rspSlotDetailDto;
    }

    @Override
    public RspSlotBackendDetailDto getBackendSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = this.soltService.selectById(slotId);
        RspSlotBackendDetailDto rspBackendSlotDetailDto = new RspSlotBackendDetailDto();
        Integer pictureSize = sltoDto.getPictureSize();
        rspBackendSlotDetailDto.setSlotId(sltoDto.getId());
        rspBackendSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspBackendSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspBackendSlotDetailDto.setAppId(sltoDto.getAppId());
        rspBackendSlotDetailDto.setPictureSize(pictureSize);
        rspBackendSlotDetailDto.setActivityUrl(sltoDto.getActivityUrl());
        rspBackendSlotDetailDto.setActivityTargetUrl(sltoDto.getActivityTargetUrl());
        rspBackendSlotDetailDto.setSlotExposeLimit(sltoDto.getSlotExposeLimit() == 0 ? null : sltoDto.getSlotExposeLimit());
        rspBackendSlotDetailDto.setActivityExposeLimit(sltoDto.getActivityExposeLimit() == 0 ? null : sltoDto.getActivityExposeLimit());
        rspBackendSlotDetailDto.setVisibleOfIco(sltoDto.isVisibleOfIco());
        rspBackendSlotDetailDto.setVisibleOfCloseButton(sltoDto.isVisibleOfCloseButton());
        Map<Long, String> map = this.materialSpecificationService.getMsNameByIds(Lists.newArrayList((Object[])new Long[]{sltoDto.getSlotMsId()}));
        rspBackendSlotDetailDto.setMsName(map.get(sltoDto.getSlotMsId()));
        if (7 == sltoDto.getSlotType()) {
            rspBackendSlotDetailDto.setFlowType(UserDefinedPictureSizeEnmu.getFlowTypeBySizeId((int)pictureSize));
        }
        if (2 == sltoDto.getSlotType()) {
            rspBackendSlotDetailDto.setFlowType(InformationStreamPictureSizeEnmu.getFlowTypeBySizeId((int)pictureSize));
        }
        MediaAppDto mediaAppDto = this.mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspBackendSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        RspShieldStrategy rspShieldStrategy = this.strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspBackendSlotDetailDto.setStrategyId(strategyId);
            rspBackendSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspBackendSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspBackendSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspBackendSlotDetailDto.setAdvertTagNumsFlag(rspShieldStrategy.isAdvertTagNumsFlag());
            if (CollectionUtils.isNotEmpty(rspShieldStrategy.getShieldIndustries())) {
                DubboResult industriesTagDubboResult = this.remoteTagBackendService.getListByNums(rspShieldStrategy.getShieldIndustries());
                this.doTuiaMediaException(industriesTagDubboResult, "remoteTagBackendService.getListByNums");
                List industriesTagDtos = (List)industriesTagDubboResult.getResult();
                ArrayList<TagLevel> industriesTagNums = new ArrayList<TagLevel>(industriesTagDtos.size());
                for (TagDto tagDto : industriesTagDtos) {
                    industriesTagNums.add(new TagLevel(tagDto.getTagNum(), tagDto.getTag()));
                }
                rspBackendSlotDetailDto.setShieldIndustries(industriesTagNums);
            }
            if (CollectionUtils.isNotEmpty(rspShieldStrategy.getAdvertTagNums())) {
                DubboResult advertTagDubboResult = this.remoteTagBackendService.getListByNums(rspShieldStrategy.getAdvertTagNums());
                this.doTuiaMediaException(advertTagDubboResult, "remoteTagBackendService.getListByNums");
                List advertTagDtos = (List)advertTagDubboResult.getResult();
                ArrayList<TagLevel> advertTagNums = new ArrayList<TagLevel>(advertTagDtos.size());
                for (TagDto tagDto : advertTagDtos) {
                    advertTagNums.add(new TagLevel(tagDto.getTagNum(), tagDto.getTag()));
                }
                rspBackendSlotDetailDto.setAdvertTagNums(advertTagNums);
            }
            rspBackendSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }
        return rspBackendSlotDetailDto;
    }

    @Override
    public Boolean updateSlotStrategy(ReqUpdateSlotStrategy param) throws TuiaMediaException {
        ShieldStrategyDto strategyDto = new ShieldStrategyDto();
        strategyDto.setId(param.getStrategyId());
        strategyDto.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        strategyDto.setShieldUrls(StringTool.getStringByList(param.getShieldAdvertisers()));
        strategyDto.setAdvertTagNums(StringTool.getStringByList(param.getAdvertTagNums()));
        this.strategyService.updateByManager(strategyDto);
        return true;
    }

    @Override
    public List<SlotTypeParamDto> buildSoltTypeParam() throws TuiaMediaException {
        ArrayList<SlotTypeParamDto> slotParamList = new ArrayList<SlotTypeParamDto>();
        ArrayList<String> plaqueList = new ArrayList<String>();
        ArrayList<String> streamerBannerList = new ArrayList<String>();
        ArrayList<String> bannerList = new ArrayList<String>();
        ArrayList<String> buoyList = new ArrayList<String>();
        ArrayList<String> appWallList = new ArrayList<String>();
        ArrayList<String> streamList = new ArrayList<String>();
        ArrayList<String> flowList = new ArrayList<String>();
        ArrayList<String> openScreenList = new ArrayList<String>();
        ArrayList<String> userDefinedList = new ArrayList<String>(11);
        for (int i = 0; i < 9; ++i) {
            SlotTypeParamDto dto = new SlotTypeParamDto();
            if (i == 0) {
                dto.setSlotType("\u63d2\u5c4f");
                plaqueList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_41.getSizeId()));
                dto.setPictureSize(plaqueList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 1) {
                dto.setSlotType("\u6a2a\u5e45");
                streamerBannerList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_61.getSizeId()));
                dto.setPictureSize(streamerBannerList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 2) {
                dto.setSlotType("\u4fe1\u606f\u6d41");
                flowList.add("750*420");
                flowList.add("750*180");
                streamList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_0.getSizeId()));
                streamList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_1.getSizeId()));
                dto.setPictureSize(streamList);
                dto.setFlowType(flowList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 3) {
                dto.setSlotType("banner");
                bannerList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_81.getSizeId()));
                dto.setPictureSize(bannerList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 4) {
                dto.setSlotType("\u6d6e\u6807");
                buoyList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_21.getSizeId()));
                dto.setPictureSize(buoyList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 5) {
                dto.setSlotType("\u5e94\u7528\u5899");
                appWallList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_21.getSizeId()));
                dto.setPictureSize(appWallList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 6) {
                dto.setSlotType("\u5f00\u5c4f");
                openScreenList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_91.getSizeId()));
                dto.setPictureSize(openScreenList);
                slotParamList.add(dto);
                continue;
            }
            if (i == 7) {
                dto.setSlotType("\u81ea\u5b9a\u4e49");
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_0.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_1.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_61.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_41.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_42.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_81.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_91.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_92.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_93.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_94.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr((int)SlotPictureSizeEnmu.SIZE_95.getSizeId()));
                dto.setFlowType(userDefinedList);
                dto.setPictureSize(userDefinedList);
                slotParamList.add(dto);
                continue;
            }
            if (i != 8) continue;
            dto.setSlotType("\u624b\u52a8\u6295\u653e");
            slotParamList.add(dto);
        }
        return slotParamList;
    }
}

