/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SlotDAOImpl
extends BaseDAO
implements SlotDAO {
    @Override
    public int insert(SlotDto slotDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)slotDto);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.insert data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(SlotDto adsenseDto) throws TuiaMediaException {
        try {
            Date date = new Date();
            adsenseDto.setGmtModified(date);
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)adsenseDto);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.update data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<SlotDto> selectListByPage(ReqSlotList param) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListByPage"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectListByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectAmountByPage(ReqSlotList param) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAmountByPage"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectAmountByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateEnableStatus(Long slotId, int enableStatus) throws TuiaMediaException {
        try {
            HashMap<String, Number> param = new HashMap<String, Number>();
            param.put("slotId", slotId);
            param.put("enableStatus", enableStatus);
            return this.getSqlSession().update(this.getStamentNameSpace("updateEnableStatus"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.updateEnableStatus data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public SlotDto selectById(Long slotId) throws TuiaMediaException {
        try {
            return (SlotDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectById"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectById data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateCheckStatus(Long slotId, int checkStatus) throws TuiaMediaException {
        try {
            List<Long> slotIds = Collections.singletonList(slotId);
            return this.batchUpdateCheckStatus(slotIds, checkStatus);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.updateAdsenseCheckStatus data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int batchUpdateCheckStatus(List<Long> slotIds, int checkStatus) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return 0;
        }
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("slotIds", slotIds);
            param.put("checkStatus", checkStatus);
            return this.getSqlSession().update(this.getStamentNameSpace("batchUpdateCheckStatus"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.batchUpdateCheckStatus data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectAdsenseAmountByPage(ReqGetSlotsByPageDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("req", req);
            param.put("appIdsList", appIdsList);
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAdsenseAmountByPage"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectAdsenseAmountByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<SlotDto> selectListAdsenseByPage(ReqGetSlotsByPageDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("req", req);
            param.put("appIdsList", appIdsList);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListAdsenseByPage"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectAdsenseListByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<SlotDto> selectListDetail(List<Long> slotIds) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return Collections.emptyList();
        }
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListDetail"), slotIds);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.getListDetail data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectIdsByName(String slotName) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectIdsByName"), (Object)slotName);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectIdsByName data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> slotIds) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAppIdAndName"), slotIds);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectAppIdAndName data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int batchUpdateEnableStatus(List<Long> slotIds, int enableStatus) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return 0;
        }
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("slotIds", slotIds);
            param.put("enableStatus", enableStatus);
            return this.getSqlSession().update(this.getStamentNameSpace("batchUpdateEnableStatus"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.batchUpdateEnableStatus data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<IdAndName> selectAllSlotIdAndName() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAllSlotIdAndName"));
        }
        catch (Exception e) {
            this.logger.error("SlotDAO.selectAllSlotIdAndName data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

