/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySlotBackendService;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySlotBackendServiceImpl
extends BaseRemoteService
implements RemoteActivitySlotBackendService {
    @Autowired
    private ActivitySlotService activitySlotService;
    @Autowired
    private SlotService slotService;

    public DubboResult<Boolean> addSlots(List<Long> slotIds) {
        try {
            return DubboResult.successResult((Object)this.activitySlotService.addSlots(slotIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySlotBackendService.addSlots is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> deleteSlot(Long slotId) {
        try {
            return DubboResult.successResult((Object)this.activitySlotService.deleteSlot(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySlotBackendService.deleteSlot is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<PageResultDto<RspActivitySlotDto>> getList(ReqActivitySlotDto req) {
        try {
            return DubboResult.successResult((Object)new PageResultDto(this.activitySlotService.getListAmount(req), this.activitySlotService.getList(req), req.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySlotBackendService.getList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<SlotDto>> getSlotByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(this.slotService.getListDetail(ids));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySlotBackendService.getSlotByIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivitySlotDto> getById(Long slotId) {
        try {
            ActivitySlotDO activitySlotDO = this.activitySlotService.getById(slotId);
            RspActivitySlotDto rspActivitySlotDto = new RspActivitySlotDto();
            if (activitySlotDO != null) {
                BeanUtils.copyProperties((Object)activitySlotDO, (Object)rspActivitySlotDto);
            }
            return DubboResult.successResult((Object)rspActivitySlotDto);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySlotBackendService.getById is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> updateDirectMode(Long slotId, Integer directMode) {
        try {
            return DubboResult.successResult((Object)this.activitySlotService.updateDirectMode(slotId, directMode));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySlotBackendService.updateDirectMode is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

