/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationAssortDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationItemContentDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationItemDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.parser.ActivityDtoParser;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.CacheService.ActivityCacheService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityNewService")
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private MaterialSpecificationItemContentDAO materialSpecificationItemContentDAO;
    @Autowired
    private ActivityCacheService activityCacheService;
    @Autowired
    private MaterialSpecificationService materialSpecificationService;
    @Autowired
    private ActivitySortService activitySortService;

    @Override
    public List<RspActivityDto> getPlanList(ReqActivityDto req) throws TuiaMediaException {
        req.setSort("gmt_modified");
        req.setOrder("desc");
        List<ActivityDto> result = this.activityDAO.getList(req);
        ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
        for (ActivityDto activityDto : result) {
            list.add(ActivityDtoParser.parseToRspActivityDto(activityDto));
        }
        return list;
    }

    @Override
    public int getPlanListAmount(ReqActivityDto req) throws TuiaMediaException {
        return this.activityDAO.getListAmount(req);
    }

    @Override
    @Transactional
    public Boolean addActivityPlan(List<ReqIdAndType> activities) throws TuiaMediaException {
        for (ReqIdAndType idAndType : activities) {
            ActivityDto activityDto = new ActivityDto();
            activityDto.setActivityId(idAndType.getId());
            activityDto.setActivityType(idAndType.getType());
            activityDto.setIsPublish(1);
            this.activityDAO.update(activityDto);
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateActivityPlan(ReqActivityDto reqActivityDto) throws TuiaMediaException {
        List activityMsIdList = reqActivityDto.getMsIdList();
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(reqActivityDto.getId());
        activityDto.setActivityType(reqActivityDto.getType());
        activityDto.setActivityMsList(Joiner.on((String)",").appendTo(new StringBuilder(), (Iterable)activityMsIdList).toString());
        this.activityDAO.update(activityDto);
        List itemContentDtoList = reqActivityDto.getItemContentList();
        this.materialSpecificationItemContentDAO.delete(reqActivityDto.getId(), reqActivityDto.getType());
        if (!CollectionUtils.isEmpty((Collection)itemContentDtoList)) {
            ArrayList<MaterialSpecificationItemContentDO> msItemContentList = new ArrayList<MaterialSpecificationItemContentDO>();
            for (RspMaterialSpecificationItemContentDto msItemContent : itemContentDtoList) {
                MaterialSpecificationItemContentDO itemContentDO = new MaterialSpecificationItemContentDO();
                BeanUtils.copyProperties((Object)msItemContent, (Object)itemContentDO);
                msItemContentList.add(itemContentDO);
            }
            this.materialSpecificationItemContentDAO.insertBatch(msItemContentList);
        }
        return true;
    }

    @Override
    public RspActivityDto getActivityPlanDetail(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = this.activityCacheService.get(activityId, activityType);
        if (activityDto == null) {
            activityDto = this.activityDAO.getDetail(activityId, activityType);
        }
        if (activityDto == null) {
            throw new TuiaMediaException(ErrorCode.E0501004);
        }
        return ActivityDtoParser.parseToRspActivityDto(activityDto);
    }

    @Override
    public Boolean changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) throws TuiaMediaException {
        if (0 != enableStatus && 1 != enableStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsEnable(enableStatus);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    @Transactional
    public Boolean deleteActivityPlan(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsPublish(0);
        this.activitySortService.deleteActivity(null, activityId, activityType);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public List<RspActivityDto> getActivityByIds(List<Long> ids) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<ActivityDto> result = this.activityDAO.getByIds(ids);
        ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
        for (ActivityDto activityDto : result) {
            list.add(ActivityDtoParser.parseToRspActivityDto(activityDto));
        }
        return list;
    }

    @Override
    public Boolean insertActivity(ActivityDto activityDto) throws TuiaMediaException {
        return this.activityDAO.insert(activityDto) == 1;
    }

    @Override
    public Boolean updateActivity(ActivityDto activityDto) throws TuiaMediaException {
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public Boolean deleteActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDelete(1);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public String getActivityName(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = this.activityDAO.getDetail(activityId, activityType);
        if (activityDto != null) {
            return activityDto.getActivityName();
        }
        return null;
    }

    @Override
    public RspActivityDto getMsItemContent(RspActivityDto rspActivityDto) throws TuiaMediaException {
        if (rspActivityDto == null) {
            return null;
        }
        ArrayList<RspMaterialSpecificationDto> msItemContentList = new ArrayList<RspMaterialSpecificationDto>();
        List msIds = rspActivityDto.getMsIdList();
        if (!CollectionUtils.isEmpty((Collection)msIds)) {
            for (Long msId : msIds) {
                RspMaterialSpecificationDto rspMaterialSpecificationDto = this.materialSpecificationService.getMaterialSpecificationDetail(msId);
                List<MaterialSpecificationItemContentDO> list = this.materialSpecificationItemContentDAO.getByActivity(rspActivityDto.getId(), rspActivityDto.getType());
                List msItemList = rspMaterialSpecificationDto.getItemDtoList();
                HashMap<Long, RspMaterialSpecificationItemDto> msItemMap = new HashMap<Long, RspMaterialSpecificationItemDto>();
                for (RspMaterialSpecificationItemDto msItem : msItemList) {
                    msItemMap.put(msItem.getId(), msItem);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    ArrayList<RspMaterialSpecificationAssortDto> sortItemContent = new ArrayList<RspMaterialSpecificationAssortDto>(list.get(list.size() - 1).getItemIndex());
                    for (int i = 0; i < list.get(list.size() - 1).getItemIndex(); ++i) {
                        RspMaterialSpecificationAssortDto msAssortDto = new RspMaterialSpecificationAssortDto();
                        msAssortDto.setId(Integer.valueOf(i));
                        msAssortDto.setValue(new ArrayList());
                        sortItemContent.add(msAssortDto);
                    }
                    for (MaterialSpecificationItemContentDO msItemContent : list) {
                        RspMaterialSpecificationItemContentDto rspMsItemContent = new RspMaterialSpecificationItemContentDto();
                        BeanUtils.copyProperties((Object)msItemContent, (Object)rspMsItemContent);
                        RspMaterialSpecificationItemDto msItem = (RspMaterialSpecificationItemDto)msItemMap.get(rspMsItemContent.getMsItemId());
                        if (msItem != null) {
                            rspMsItemContent.setItemType(msItem.getItemType());
                            rspMsItemContent.setDescription(msItem.getDescription());
                            rspMsItemContent.setImageHeight(msItem.getImageHeight());
                            rspMsItemContent.setImageWidth(msItem.getImageWidth());
                        }
                        ((RspMaterialSpecificationAssortDto)sortItemContent.get(msItemContent.getItemIndex() - 1)).getValue().add(rspMsItemContent);
                    }
                    rspMaterialSpecificationDto.setItemContentList(sortItemContent);
                }
                msItemContentList.add(rspMaterialSpecificationDto);
            }
        }
        rspActivityDto.setMsList(msItemContentList);
        return rspActivityDto;
    }

    @Override
    public List<Long> getIdsByName(String name) throws TuiaMediaException {
        return this.activityDAO.getIdsByName(name);
    }

    @Override
    public List<RspMaterialSpecificationDto> getMsItemList() throws TuiaMediaException {
        ReqMaterialSpecificationDto req = new ReqMaterialSpecificationDto();
        req.setPageSize(Integer.valueOf(-1));
        List<RspMaterialSpecificationDto> list = this.materialSpecificationService.getMaterialSpecificationList(req);
        ArrayList<RspMaterialSpecificationDto> result = new ArrayList<RspMaterialSpecificationDto>();
        for (RspMaterialSpecificationDto ms : list) {
            try {
                result.add(this.materialSpecificationService.getMaterialSpecificationDetail(ms.getId()));
            }
            catch (Exception e) {}
        }
        return result;
    }
}

