package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;

/**
 * Function: ActivityDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivityDAO {

    /**
     * insert
     *
     * @param activityDto
     * @return affect line
     */
    int insert(ActivityDto activityDto) throws TuiaMediaException;

    /**
     * update
     *
     * @param activityDto
     * @return affect line
     */
    int update(ActivityDto activityDto) throws TuiaMediaException;

    /**
     * getList
     *
     * @param req
     * @return 活动列表
     */
    List<ActivityDto> getList(ReqActivityDto req) throws TuiaMediaException;

    /**
     * 数量计算
     *
     * @param req
     * @return 数量
     */
    int getListAmount(ReqActivityDto req) throws TuiaMediaException;

    /**
     * 根据活动ID获取活动列表
     *
     * @param ids 活动ID列表
     * @return 活动列表
     */
    List<ActivityDto> getByIds(List<Long> ids) throws TuiaMediaException;

    /**
     * getDetail
     *
     * @param activityId
     * @param activityType
     * @return ActivityDto
     */
    ActivityDto getDetail(Long activityId, Integer activityType) throws TuiaMediaException;

    /**
     * getIdsByName
     * 
     * @param name
     * @return ID列表
     */
    List<Long> getIdsByName(String name) throws TuiaMediaException;
}
