package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface MaterialSpecificationItemContentDAO {

    /**
     * insertBatch
     * 
     * @param list
     * @return affect line
     */
    int insertBatch(List<MaterialSpecificationItemContentDO> list) throws TuiaMediaException;

    /**
     * delete
     * 
     * @param activityId
     * @param activityType
     * @return affect line
     */
    int delete(Long activityId, Integer activityType) throws TuiaMediaException;

    /**
     * 判断活动是否有素材
     * 
     * @param activityId
     * @param activityType
     * @return 活动素材
     */
    int itemContentAmount(Long activityId, Integer activityType) throws TuiaMediaException;

    /**
     * getByActivity:获取某个活动某个规格下的所有素材
     * 
     * @param activityId
     * @param activityType
     * @param msId
     * @return 素材列表
     */
    List<MaterialSpecificationItemContentDO> getByActivity(Long activityId, Integer activityType, Long msId) throws TuiaMediaException;
}
