/**
 * Project Name:media-biz<br/>
 * File Name:AccountChangeDAOImpl.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br/>
 * Date:2016年12月6日下午7:47:51<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountChangeDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;

/**
 * ClassName:AccountChangeDAOImpl <br/>
 * Date: 2016年12月6日 下午7:47:51 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@Repository("accountChangeDAO")
public class AccountChangeDAOImpl extends BaseDAO implements AccountChangeDAO {

    @Override
    public int selectAccountChangeCount(ReqAccountChange req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAccountChangeCount"), req);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountChangeCount data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeByPage(ReqAccountChange req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectAccountChangeByPage"), req);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountChangeList data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public void insertAccountChange(AccountChangeDto accountChangeDto) throws TuiaMediaException {
        try {
            getSqlSession().insert(getStamentNameSpace("insertAccountChange"), accountChangeDto);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.insertAccountChange data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }

    }

    @Override
    public Long selectAccountBalance(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAccountBalance"), mediaId);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountBalance data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeListByIds(List<Long> ids) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectAccountChangeListByIds"), ids);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountChangeListByIds data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public AccountChangeDto selectAccountChangeById(Long id) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAccountChangeById"), id);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountChangeById data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public AccountChangeDto selectAccountChangeByMediaId(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAccountChangeByMediaId"), mediaId);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountChangeByMediaId data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeList(ReqAccountChange req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectAccountChangeList"), req);
        } catch (Exception e) {
            logger.error("AccountChangeDAOImpl.selectAccountChangeList data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
