package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAdvertDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityAdvertDO;

import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
@Repository("activityAdvertDAO")
public class ActivityAdvertDAOImpl extends BaseDAO implements ActivityAdvertDAO {

    @Override
    public int insertBatch(List<ActivityAdvertDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("ActivityAdvertDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().delete(getStamentNameSpace("delete"), map);
        } catch (Exception e) {
            logger.error("ActivityAdvertDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
