package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemDO;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
@Repository("materialSpecificationItemDAO")
public class MaterialSpecificationItemDAOImpl extends BaseDAO implements MaterialSpecificationItemDAO {

    @Override
    public int insertBatch(List<MaterialSpecificationItemDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), list);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemDAO.insertBatch happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MaterialSpecificationItemDO> getByMsId(Long msId) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("getByMsId"), msId);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemDAO.getByMsId happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(MaterialSpecificationItemDO materialSpecificationItemDO) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), materialSpecificationItemDO);
        } catch (Exception e) {
            logger.error("MaterialSpecificationItemDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
