/**
 * Project Name:media-biz<br>
 * File Name:MediaActSlotStatDayDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年12月29日下午2:20:13<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.springframework.stereotype.Repository;
import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaActSlotStatDayDAO;

/**
 * ClassName: MediaActSlotStatDayDAOImpl <br/>
 * date: 2016年12月29日 下午2:20:13 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Repository
public class MediaActSlotStatDayDAOImpl extends BaseDAO implements MediaActSlotStatDayDAO {

    @SuppressWarnings("unchecked")
    @Override
    public List<MeidaActivitySlotStatisticsDto> selectByActIds(List<Long> actIds,String yesterday) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(actIds)) {
            return ListUtils.EMPTY_LIST;
        }
        try {
            Map<String,Object> param=new HashMap<>(2);
            param.put("yesterday", yesterday);
            param.put("actIds", actIds);
            return getSqlSession().selectList(getStamentNameSpace("selectByActIds"), param);
        } catch (Exception e) {
            logger.error("MediaActSlotStatDayDAO.selectByActIds happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

}
