/**
 * Project Name:media-biz<br>
 * File Name:StatisticsDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao.impl<br>
 * Date:2016年10月10日下午4:33:14<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.DataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotStatisticsDAO;

/**
 * ClassName: SlotStatisticsDAOImpl <br/>
 * date: 2016年10月10日 下午4:33:14 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Repository
public class SlotStatisticsDAOImpl extends BaseDAO implements SlotStatisticsDAO {

    private String appIdsListStr = "appIdsList";

    @Override
    public int selectSlotDataAmout(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList)
                                                                                                           throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(3);
            param.put("req", req);
            param.put("slotIdsList", slotIdsList);
            param.put(appIdsListStr, appIdsList);
            return getSqlSession().selectOne(getStamentNameSpace("selectSlotDataAmout"), param);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectSlotDataAmout data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<SlotStatisticsDto> selectListSlotDataByPage(ReqSlotStatisticsDto req, List<Long> slotIdsList,
                                                            List<Long> appIdsList) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(3);
            param.put("req", req);
            param.put("slotIdsList", slotIdsList);
            param.put(appIdsListStr, appIdsList);
            return getSqlSession().selectList(getStamentNameSpace("selectListSlotDataByPage"), param);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectListSlotDataByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectMediaDataAmount(ReqMediaAppStatisticsDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("req", req);
            param.put(appIdsListStr, appIdsList);
            return getSqlSession().selectOne(getStamentNameSpace("selectMediaDataAmount"), param);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectMediaDataAmount data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MediaAppStatisticsDto> selectListMediaDataByPage(ReqMediaAppStatisticsDto req, List<Long> appIdsList)
                                                                                                                     throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("req", req);
            param.put(appIdsListStr, appIdsList);
            return getSqlSession().selectList(getStamentNameSpace("selectListMediaDataByPage"), param);
        } catch (Exception e) {
            logger.error("SlotStatisticsDAOImpl.selectListMediaDataByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<DataStatisticsDto> selectByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByDate"), param);
        } catch (Exception e) {
            logger.error("the SlotStatisticsDAOImpl.selectByDate data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }

    }

}
