package cn.com.duiba.tuia.media.domain;

import cn.com.duiba.tuia.media.api.dto.BaseDto;

/**
 * Function: 活动排序表
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public class ActivitySortDto extends BaseDto implements Comparable<ActivitySortDto> {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 5408526296410796899L;

    /** 活动ID */
    private Long              activityId;

    /** 活动类型 */
    private Integer           activityType;

    /** 活动媒体ID */
    private Long              activityAppId;

    /** 活动广告位ID */
    private Long              activitySlotId;

    /** 排序字段 */
    private Long              activitySort;

    /** 活动名称 */
    private String            activityName;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getActivityAppId() {
        return activityAppId;
    }

    public void setActivityAppId(Long activityAppId) {
        this.activityAppId = activityAppId;
    }

    public Long getActivitySlotId() {
        return activitySlotId;
    }

    public void setActivitySlotId(Long activitySlotId) {
        this.activitySlotId = activitySlotId;
    }

    public Long getActivitySort() {
        return activitySort;
    }

    public void setActivitySort(Long activitySort) {
        this.activitySort = activitySort;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @Override
    public int compareTo(ActivitySortDto o) {
        if (o.getActivitySort() > activitySort) {
            return -1;
        }
        return 1;
    }
}
