/**
 * Project Name:media-biz File Name:RemoteMediaAppConfigServiceImpl.java Package
 * Name:cn.com.duiba.tuia.media.remoteservice Date:2016年10月8日下午3:21:38 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.media.remoteservice;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaAppConfigBackendService;
import cn.com.duiba.tuia.media.service.MediaAppConfigService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaAppConfigServiceImpl <br/>
 * Function: 媒体信息配置 <br/>
 * Date: 2016年10月8日 下午3:21:38 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */

public class RemoteMediaAppConfigBackendServiceImpl extends BaseRemoteService implements RemoteMediaAppConfigBackendService {

    @Autowired
    private MediaAppConfigService mediaAppConfigService;

    @Override
    public DubboResult<PageResultDto<RspMediaAppConfigDto>> getMediaAppConfigByPage(ReqGetMediaAppConfigByPageDto req) {
        try {
            return DubboResult.successResult(this.mediaAppConfigService.getMediaAppCondfigList(req));
        } catch (Exception e) {
            logger.error("RemoteMediaAppConfigBackendServiceImpl.getMediaAppConfigByPage is error", e);
            return exceptionFailure(e);
        }

    }

    @Override
    public DubboResult<MediaAppConfigDto> getMediaAppConfig(Long appId) {
        try {
            return DubboResult.successResult(this.mediaAppConfigService.getMediaAppConfigMsg(appId));
        } catch (Exception e) {
            logger.error("RemoteMediaAppConfigBackendServiceImpl.getMediaAppConfig is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> updateMediaAppConfig(ReqUpdateMediaAppConfigDto param) {
        try {
            return DubboResult.successResult(this.mediaAppConfigService.updateMediaAppConfig(param));
        } catch (Exception e) {
            logger.error("RemoteMediaAppConfigBackendServiceImpl.updateMediaAppConfig is error", e);
            return exceptionFailure(e);
        }
    }

}
