/**
 * Project Name:media-biz<br>
 * File Name:accountCheckRecordService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月30日下午4:28:15<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.AccountCheckRecordDto;

/**
 * ClassName: accountCheckRecordService <br/>
 * date: 2016年9月30日 下午4:28:15 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountCheckRecordService {

    /**
     * 插入审核记录.
     *
     * @param checkRecord the check record
     * @return true, if insert check record
     * @throws TuiaMediaException the tuia media exception
     */
    boolean insertCheckRecord(AccountCheckRecordDto checkRecord) throws TuiaMediaException;

    /**
     * 查询最新一条审核记录.
     *
     * @param mediaId the media id
     * @param status the status
     * @return the account check record dto
     * @throws TuiaMediaException the tuia media exception
     */
    AccountCheckRecordDto selectLatelyCheckRecord(long mediaId, Integer status) throws TuiaMediaException;
}
