/**
 * Project Name:media-biz File Name:MediaAppConfig.java Package Name:cn.com.duiba.tuia.media.service
 * Date:2016年10月8日下午3:28:24 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppConfigDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:MediaAppConfig <br/>
 * Function: 媒体配置信息. <br/>
 * Date: 2016年10月8日 下午3:28:24 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface MediaAppConfigService {

    /**
     * 创建媒体配置信息
     * 
     * @param param
     * @return
     * @throws TuiaMediaException
     */
    Boolean createMediaAppConfig(ReqCreateMediaAppConfigDto param) throws TuiaMediaException;

    /**
     * 
     * getMediaAppCondfigList:(创建媒体配置信息列表). <br/>
     *
     * @author ZFZ
     * @param mediaAppConfigQuery
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    PageResultDto<RspMediaAppConfigDto> getMediaAppCondfigList(ReqGetMediaAppConfigByPageDto mediaAppConfigQuery)
                                                                                                                 throws TuiaMediaException;

    /**
     * 查看媒体配置信息
     * 
     * @param appId
     * @return
     * @throws TuiaMediaException
     */
    MediaAppConfigDto getMediaAppConfigMsg(Long appId) throws TuiaMediaException;

    /**
     * 
     * updateMediaAppConfig:(修改媒体配置信息). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Boolean updateMediaAppConfig(ReqUpdateMediaAppConfigDto param) throws TuiaMediaException;
}
