package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface MediaAppMsService {

    /**
     * 规格定向到媒体
     *
     * @param msId 规格ID
     * @param appIds 媒体ID列表
     * @param directStatus
     * @return Boolean
     */
    Boolean msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus) throws TuiaMediaException;

    /**
     * 获取规格定向的媒体列表
     * 
     * @param msId 规格ID
     * @return 媒体ID列表
     */
    List<Long> getMsDirectedMediaApp(Long msId) throws TuiaMediaException;

    /**
     * 获取定向到其他媒体的所有规格
     * 
     * @param mediaId 媒体ID
     * @return 规格列表
     */
    List<Long> getMsIdsExceptTheMediaApp(Long mediaId) throws TuiaMediaException;

    /**
     * 获取定向到指定媒体的所有规格
     *
     * @param mediaId 媒体ID
     * @return 规格列表
     */
    List<Long> getMsIdsByMediaApp(Long mediaId) throws TuiaMediaException;
}
