package cn.com.duiba.tuia.media.service.cacheservice;

import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.utils.JsonUtils;
import cn.com.duiba.wolf.redis.RedisClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
@Service
public class ActivityCacheService {

    @Autowired
    private RedisClient redisClient;

    /**
     * 从缓存获取活动，key=id+type
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 活动
     */
    public ActivityDto get(Long activityId, Integer activityType) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey(activityId + "-" + activityType);
        String value = redisClient.get(key);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return JsonUtils.jsonToObject(ActivityDto.class, value);
    }

    /**
     * 活动写入缓存
     * 
     * @param activityDto 活动
     */
    public void set(ActivityDto activityDto) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey(activityDto.getActivityId() + "-" + activityDto.getActivityType());
        String value = JsonUtils.objectToString(activityDto);
        redisClient.set(key, value);
    }
}
