/**
 * Project Name:media-biz<br>
 * File Name:AccountCheckRecordServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.service.impl<br>
 * Date:2016年9月30日下午4:30:21<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountCheckRecordDAO;
import cn.com.duiba.tuia.media.domain.AccountCheckRecordDto;
import cn.com.duiba.tuia.media.service.AccountCheckRecordService;

/**
 * ClassName: AccountCheckRecordServiceImpl <br/>
 * date: 2016年9月30日 下午4:30:21 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Service
public class AccountCheckRecordServiceImpl implements AccountCheckRecordService {

    @Autowired
    private AccountCheckRecordDAO accountCheckRecordDAO;

    @Override
    public boolean insertCheckRecord(AccountCheckRecordDto checkRecord) throws TuiaMediaException {
        return accountCheckRecordDAO.insertCheckRecord(checkRecord) == 1 ? true : false;
    }

    @Override
    public AccountCheckRecordDto selectLatelyCheckRecord(long mediaId, Integer status) throws TuiaMediaException {
        return accountCheckRecordDAO.selectLatelyCheckRecord(mediaId, status);
    }

}
