/**
 * Project Name:media-biz File Name:DataStatisticsBo.java Package Name:cn.com.duiba.tuia.media.bo
 * Date:2016年10月12日下午5:04:07 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.bo;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotLineStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppDataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDataStatisticsDto;

/**
 * ClassName:DataStatisticsBo <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月12日 下午5:04:07 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface SlotLineStatisticsBO {

    /**
     * selectStatisticsDataByDate:(根据开始日期和结束日期 获取 总的 '点击量','曝光量','eCPM','预计收入' 统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    RspSlotLineStatisticsDto selectStatisticsDataByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;

    /**
     * getMediaAppStatisticsData:(获取媒体app统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    PageResultDto<RspMediaAppDataStatisticsDto> getMediaAppStatisticsData(ReqSlotLineStatisticsByPageDto param)
                                                                                                               throws TuiaMediaException;

    /**
     * getSlotStatisticsData:(获取广告位统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    PageResultDto<RspSlotDataStatisticsDto> getSlotStatisticsData(ReqSlotLineStatisticsByPageDto param)
                                                                                                       throws TuiaMediaException;

}
