/**
 * Project Name:media-biz<br>
 * File Name:SlotBoImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo.impl<br>
 * Date:2016年10月8日下午5:38:15<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.bo.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.media.service.*;

import com.google.common.collect.Lists;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.core.api.dto.TagDto;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteTagBackendService;
import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.TagLevel;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotBackendDetailDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.InformationStreamPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.constants.UserDefinedPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.utils.StringTool;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: SlotBoImpl <br/>
 * date: 2016年10月8日 下午5:38:15 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Service
public class SlotBackendBOImpl extends BaseService implements SlotBackendBo {

    @Autowired
    private SlotService                  soltService;

    @Autowired
    private StrategyService              strategyService;

    @Autowired
    private MediaAppService              mediaAppService;

    @Autowired
    private RemoteTagBackendService      remoteTagBackendService;

    @Autowired
    private MaterialSpecificationService materialSpecificationService;

    @Autowired
    private ActivityService              activityService;

    @Autowired
    private ActivityManualService        activityManualService;

    @Override
    public Boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException {

        // 广告位已经审核过
        List<SlotDto> slotDtoList = soltService.getListDetail(slotIds);
        if (CollectionUtils.isNotEmpty(slotDtoList)) {
            for (SlotDto slotDto : slotDtoList) {
                if (SlotDto.CHECK_STATUS_PASS == slotDto.getCheckStatus() || SlotDto.CHECK_STATUS_FAIL == slotDto.getCheckStatus()) {
                    logger.error("the slot is checked id = [{}]", slotDto.getId());
                    throw new TuiaMediaException(ErrorCode.E0304007);
                }
            }
        }

        // 修改媒体账户审核状态
        return soltService.batchUpdateCheckStatus(slotIds, checkType);
    }

    @Override
    public RspSlotDetailDto getSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = soltService.selectById(slotId);
        Integer pictureSize = sltoDto.getPictureSize();
        RspSlotDetailDto rspSlotDetailDto = new RspSlotDetailDto();
        rspSlotDetailDto.setSlotId(sltoDto.getId());
        rspSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspSlotDetailDto.setAppId(sltoDto.getAppId());
        rspSlotDetailDto.setPictureSize(pictureSize);
        rspSlotDetailDto.setMsId(sltoDto.getSlotMsId());
        if (SlotDto.ADSENSE_TYPE_USER_DEFINED == sltoDto.getSlotType()) {
            rspSlotDetailDto.setFlowType(UserDefinedPictureSizeEnmu.getFlowTypeBySizeId(pictureSize));
        }

        if (SlotDto.ADSENSE_TYPE_INFORMATION_STREAM == sltoDto.getSlotType()) {
            rspSlotDetailDto.setFlowType(InformationStreamPictureSizeEnmu.getFlowTypeBySizeId(pictureSize));
        }
        // 获取appName
        MediaAppDto mediaAppDto = mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        // 获取屏蔽策略
        RspShieldStrategy rspShieldStrategy = strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspSlotDetailDto.setStrategyId(strategyId);
            rspSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspSlotDetailDto.setShieldIndustries(rspShieldStrategy.getShieldIndustries());
            rspSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }

        //手动投放获取投放活动
        if (sltoDto.getSlotType() == SlotDto.ADSENSE_TYPE_MANUAL) {
            List<ActivityManualPlanDto> activityManualPlanDtos = new ArrayList<>();
            List<ActivityManualPlanDO> activityManualPlans = activityManualService.findActivityManualPlans(slotId);
            for (ActivityManualPlanDO plan : activityManualPlans) {
                ActivityManualPlanDto planDto = new ActivityManualPlanDto();
                BeanUtils.copyProperties(plan, planDto);
                if (plan.getReleaseTime() != null) {
                    planDto.setReleaseTime(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(plan.getReleaseTime()));
                }
                String activityName = activityService.getActivityName(plan.getActivityId(), plan.getActivityType());
                planDto.setActivityName(activityName);
                activityManualPlanDtos.add(planDto);
            }
            rspSlotDetailDto.setActivityManualPlans(activityManualPlanDtos);
        }
        return rspSlotDetailDto;
    }

    @Override
    public RspSlotBackendDetailDto getBackendSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = soltService.selectById(slotId);
        RspSlotBackendDetailDto rspBackendSlotDetailDto = new RspSlotBackendDetailDto();
        Integer pictureSize = sltoDto.getPictureSize();
        rspBackendSlotDetailDto.setSlotId(sltoDto.getId());
        rspBackendSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspBackendSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspBackendSlotDetailDto.setAppId(sltoDto.getAppId());
        rspBackendSlotDetailDto.setPictureSize(pictureSize);
        rspBackendSlotDetailDto.setActivityUrl(sltoDto.getActivityUrl());
        rspBackendSlotDetailDto.setActivityTargetUrl(sltoDto.getActivityTargetUrl());
        rspBackendSlotDetailDto.setSlotExposeLimit(sltoDto.getSlotExposeLimit() == 0 ? null : sltoDto.getSlotExposeLimit());
        rspBackendSlotDetailDto.setActivityExposeLimit(sltoDto.getActivityExposeLimit() == 0 ? null : sltoDto.getActivityExposeLimit());
        rspBackendSlotDetailDto.setVisibleOfIco(sltoDto.isVisibleOfIco());
        rspBackendSlotDetailDto.setVisibleOfCloseButton(sltoDto.isVisibleOfCloseButton());
        // 规格名称，没有规格就显示原有的类型名称
        Map<Long, String> map = materialSpecificationService.getMsNameByIds(Lists.newArrayList(sltoDto.getSlotMsId()));
        if (sltoDto.getSlotMsId() == null) {
            rspBackendSlotDetailDto.setMsName(SlotDto.getSlotTypeNameBySlotType(sltoDto.getSlotType()));
        } else {
            rspBackendSlotDetailDto.setMsName(map.get(sltoDto.getSlotMsId()));
        }

        if (SlotDto.ADSENSE_TYPE_USER_DEFINED == sltoDto.getSlotType()) {
            rspBackendSlotDetailDto.setFlowType(UserDefinedPictureSizeEnmu.getFlowTypeBySizeId(pictureSize));
        }

        if (SlotDto.ADSENSE_TYPE_INFORMATION_STREAM == sltoDto.getSlotType()) {
            rspBackendSlotDetailDto.setFlowType(InformationStreamPictureSizeEnmu.getFlowTypeBySizeId(pictureSize));
        }

        // 获取appName
        MediaAppDto mediaAppDto = mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspBackendSlotDetailDto.setAppName(mediaAppDto.getAppName());

        // 获取屏蔽策略
        Long strategyId = sltoDto.getStrategyId();
        RspShieldStrategy rspShieldStrategy = strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspBackendSlotDetailDto.setStrategyId(strategyId);
            rspBackendSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspBackendSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspBackendSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspBackendSlotDetailDto.setAdvertTagNumsFlag(rspShieldStrategy.isAdvertTagNumsFlag());
            if (CollectionUtils.isNotEmpty(rspShieldStrategy.getShieldIndustries())) {
                DubboResult<List<TagDto>> industriesTagDubboResult = remoteTagBackendService.getListByNums(rspShieldStrategy.getShieldIndustries());
                doTuiaMediaException(industriesTagDubboResult, "remoteTagBackendService.getListByNums");
                List<TagDto> industriesTagDtos = industriesTagDubboResult.getResult();
                List<TagLevel> industriesTagNums = new ArrayList<>(industriesTagDtos.size());
                for (TagDto tagDto : industriesTagDtos) {
                    industriesTagNums.add(new TagLevel(tagDto.getTagNum(), tagDto.getTag()));
                }
                rspBackendSlotDetailDto.setShieldIndustries(industriesTagNums);
            }
            if (CollectionUtils.isNotEmpty(rspShieldStrategy.getAdvertTagNums())) {
                DubboResult<List<TagDto>> advertTagDubboResult = remoteTagBackendService.getListByNums(rspShieldStrategy.getAdvertTagNums());
                doTuiaMediaException(advertTagDubboResult, "remoteTagBackendService.getListByNums");
                List<TagDto> advertTagDtos = advertTagDubboResult.getResult();
                List<TagLevel> advertTagNums = new ArrayList<>(advertTagDtos.size());
                for (TagDto tagDto : advertTagDtos) {
                    advertTagNums.add(new TagLevel(tagDto.getTagNum(), tagDto.getTag()));
                }
                rspBackendSlotDetailDto.setAdvertTagNums(advertTagNums);
            }
            rspBackendSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }
        return rspBackendSlotDetailDto;
    }

    @Override
    public Boolean updateSlotStrategy(ReqUpdateSlotStrategy param) throws TuiaMediaException {
        ShieldStrategyDto strategyDto = new ShieldStrategyDto();
        strategyDto.setId(param.getStrategyId());
        strategyDto.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        strategyDto.setShieldUrls(StringTool.getStringByList(param.getShieldAdvertisers()));
        strategyDto.setAdvertTagNums(StringTool.getStringByList(param.getAdvertTagNums()));
        strategyService.updateByManager(strategyDto);
        return true;
    }

    @Override
    public List<SlotTypeParamDto> buildSoltTypeParam() throws TuiaMediaException {
        List<SlotTypeParamDto> slotParamList = new ArrayList<>();
        List<String> plaqueList = new ArrayList<>();
        List<String> streamerBannerList = new ArrayList<>();
        List<String> bannerList = new ArrayList<>();
        List<String> buoyList = new ArrayList<>();
        List<String> appWallList = new ArrayList<>();
        List<String> streamList = new ArrayList<>();
        List<String> flowList = new ArrayList<>();
        List<String> openScreenList = new ArrayList<>();
        List<String> userDefinedList = new ArrayList<>(11);

        for (int i = SlotDto.ADSENSE_TYPE_PLAQUE; i < SlotDto.ADSENSE_TYPE_SIZE; i++) {
            SlotTypeParamDto dto = new SlotTypeParamDto();
            if (i == SlotDto.ADSENSE_TYPE_PLAQUE) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_PLAQUE_STR);
                plaqueList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_41.getSizeId()));
                dto.setPictureSize(plaqueList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_STREAMER_BANNER) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_STREAMER_BANNER_STR);
                streamerBannerList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_61.getSizeId()));
                dto.setPictureSize(streamerBannerList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_INFORMATION_STREAM) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_INFORMATION_STREAM_STR);
                flowList.add(SlotDto.FLOW_TYPE_SIZE_750_420);
                flowList.add(SlotDto.FLOW_TYPE_SIZE_750_180);
                streamList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_0.getSizeId()));
                streamList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_1.getSizeId()));
                dto.setPictureSize(streamList);
                dto.setFlowType(flowList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_BANNER) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_BANNER_STR);
                bannerList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_81.getSizeId()));
                dto.setPictureSize(bannerList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_BUOY) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_BUOY_STR);
                buoyList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_21.getSizeId()));
                dto.setPictureSize(buoyList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_APP_WALL) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_APP_WALL_STR);
                appWallList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_21.getSizeId()));
                dto.setPictureSize(appWallList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_OPEN_SCREEN) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_OPEN_SCREEN_STR);
                openScreenList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_91.getSizeId()));
                dto.setPictureSize(openScreenList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_USER_DEFINED) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_USER_DEFINED_STR);
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_0.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_1.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_61.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_41.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_42.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_81.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_91.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_92.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_93.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_94.getSizeId()));
                userDefinedList.add(SlotPictureSizeEnmu.getPictureSizeStr(SlotPictureSizeEnmu.SIZE_95.getSizeId()));
                dto.setFlowType(userDefinedList);
                dto.setPictureSize(userDefinedList);
                slotParamList.add(dto);
            } else if (i == SlotDto.ADSENSE_TYPE_MANUAL) {
                dto.setSlotType(SlotDto.ADSENSE_TYPE_MANUAL_STR);
                slotParamList.add(dto);
            }
        }
        return slotParamList;
    }

    @Override
    public Boolean deleteSlotById(Long slotId,Long mediaId) throws TuiaMediaException {
        SlotDto slotDto = soltService.selectById(slotId);
        if (slotDto != null && mediaId.equals(slotDto.getMediaId())) {
            Integer enableStatus = slotDto.getEnableStatus();
            if (enableStatus == SlotDto.ENABLE_STATUS_CLOSE) {
                return soltService.deleteSlotById(slotId,mediaId);
            }else if (enableStatus == SlotDto.ENABLE_STATUS_OPEN) {
               throw new TuiaMediaException(ErrorCode.E0304009);
            }
        }
        return true;
    }
}
