/**
 * Project Name:media-biz<br>
 * File Name:AccountBankDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年9月27日下午2:15:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;

/**
 * ClassName: AccountBankDAO <br/>
 * date: 2016年9月27日 下午2:15:36 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountBankDAO {

    /**
     * 
     * selectById:(通过媒体用户ID查询媒体银行账户信息.). <br/>
     *
     * @author ZFZ
     * @param media
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    AccountBankDto selectById(Long media) throws TuiaMediaException;

    /**
     * 
     * update:(更新媒体银行账户信息). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int update(ReqUpdateAccountBank req) throws TuiaMediaException;

    /**
     * 
     * insert:(插入媒体银行账户信息). <br/>
     *
     * @author ZFZ
     * @param accountBankDto
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int insert(AccountBankDto accountBankDto) throws TuiaMediaException;
}
