/**
 * Project Name:media-biz<br/>
 * File Name:AccountChangeDAO.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao<br/>
 * Date:2016年12月6日下午5:46:09<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName:AccountChangeDAO <br/>
 * Date: 2016年12月6日 下午5:46:09 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface AccountChangeDAO {

    /**
     * selectAccountChangeCount:(查询媒体账户月资金流水条数). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectAccountChangeCount(ReqAccountChange req) throws TuiaMediaException;

    /**
     * selectAccountChangeList:(分页媒体账户月资金流水记录). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountChangeDto> selectAccountChangeByPage(ReqAccountChange req) throws TuiaMediaException;

    /**
     * insertAccountChange:(增加媒体账户月资金记录). <br/>
     *
     * @author ZFZ
     * @param accountChangeDto
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    void insertAccountChange(AccountChangeDto accountChangeDto) throws TuiaMediaException;

    /**
     * selectAccountBalance:(根据mediaId查询账户当前余额). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    Long selectAccountBalance(Long mediaId) throws TuiaMediaException;

    /**
     * selectAccountChangeListByIds:(通过媒体ids查询媒体账户资金余额). <br/>
     *
     * @param ids
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountChangeDto> selectAccountChangeListByIds(List<Long> ids) throws TuiaMediaException;
    
    /**
     * 
     * selectAccountChangeById:(通过Id查询结算流水信息). <br/>
     *
     * @param id
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    AccountChangeDto selectAccountChangeById(Long id)throws TuiaMediaException;
    
    /**
     * 
     * selectAccountChangeByMediaId:(通过媒体用户Id查询最后一条结算流水信息). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    AccountChangeDto selectAccountChangeByMediaId(Long mediaId)throws TuiaMediaException;
    
    /**
     * selectAccountChangeList:(查询媒体账户月资金流水记录). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<AccountChangeDto> selectAccountChangeList(ReqAccountChange req) throws TuiaMediaException;
}
