package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface MaterialSpecificationDAO {

    /**
     * insert
     * 
     * @param materialSpecificationDO
     * @return affect line
     */
    int insert(MaterialSpecificationDO materialSpecificationDO) throws TuiaMediaException;

    /**
     * update
     * 
     * @param materialSpecificationDO
     * @return affect line
     */
    int update(MaterialSpecificationDO materialSpecificationDO) throws TuiaMediaException;

    /**
     * soft delete
     * 
     * @param msId 规格ID
     * @return affect line
     */
    int delete(Long msId) throws TuiaMediaException;

    /**
     * getList
     * 
     * @param req
     * @return 规格列表
     */
    List<MaterialSpecificationDO> getList(ReqMaterialSpecificationDto req) throws TuiaMediaException;

    /**
     * getAmount
     * 
     * @param req
     * @return amount
     */
    int getAmount(ReqMaterialSpecificationDto req) throws TuiaMediaException;

    /**
     * getById
     * 
     * @param id
     * @return MaterialSpecificationDO
     */
    MaterialSpecificationDO getById(Long id) throws TuiaMediaException;

    /**
     * getByIds
     * 
     * @param ids
     * @return 规格列表
     */
    List<MaterialSpecificationDO> getByIds(List<Long> ids) throws TuiaMediaException;
}
