/**
 * Project Name:media-biz<br>
 * File Name:MediaActSlotStatDayDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年12月29日下午2:15:00<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: MediaActSlotStatDayDAO <br/>
 * date: 2016年12月29日 下午2:15:00 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface MediaActSlotStatDayDAO {

    /**
     * 通过活动id集合批量查询前一天的数据.
     *
     * @param actIds the act ids
     * @param yesterday [yyyy-MM-dd] 表示昨天
     * @return the list< meida activity slot statistics dto>
     * @throws TuiaMediaException the tuia media exception
     */
    List<MeidaActivitySlotStatisticsDto> selectByActIds(List<Long> actIds, String yesterday) throws TuiaMediaException;
}
