package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MediaAppMsDO;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface MediaAppMsDAO {

    /**
     * insertBatch
     * 
     * @param list
     * @return affect line
     */
    int insertBatch(List<MediaAppMsDO> list) throws TuiaMediaException;

    /**
     * delete
     * 
     * @param msId 规格ID
     * @return affect line
     */
    int delete(Long msId) throws TuiaMediaException;

    /**
     * getAppIdsByMsId
     * 
     * @param msId 规格ID
     * @return 媒体ID列表
     */
    List<Long> getAppIdsByMsId(Long msId) throws TuiaMediaException;

    /**
     * 获取定向到其他媒体的所有规格
     *
     * @param mediaId 媒体ID
     * @return 规格列表
     */
    List<Long> getMsIdsExceptTheMediaApp(Long mediaId) throws TuiaMediaException;

    /**
     * 获取定向到指定媒体的所有规格
     *
     * @param mediaId 媒体ID
     * @return 规格列表
     */
    List<Long> getMsIdsByMediaApp(Long mediaId) throws TuiaMediaException;
}
