/**
 * Project Name:media-biz<br>
 * File Name:SlotStatisticsDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年10月10日下午4:32:52<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: SlotStatisticsDAO <br/>
 * date: 2016年10月10日 下午4:32:52 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface SlotStatisticsDAO {

    /**
     * selectSlotDataAmout:(分页统计广告位数据总数). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectSlotDataAmout(ReqSlotStatisticsDto req) throws TuiaMediaException;

    /**
     * selectListSlotDataByPage:(分页统计广告位数据). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> selectListSlotDataByPage(ReqSlotStatisticsDto req) throws TuiaMediaException;

    /**
     * selectMediaDataAmount:(分页统计媒体数据总数). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    int selectMediaDataAmount(ReqMediaAppStatisticsDto req) throws TuiaMediaException;

    /**
     * selectListMediaDataByPage:(分页统计媒体数据). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> selectListMediaDataByPage(ReqMediaAppStatisticsDto req)
                                                                                                throws TuiaMediaException;

    /**
     * selectByDate:(根据开始日期和结束日期 获取 总的 '点击量','曝光量','eCPM','预计收入' 统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<MeidaActivitySlotStatisticsDto> selectByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;
}
