/**
 * 
 */
package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;

/**
 * @author Administrator
 */
@Repository("accountDAO")
public class AccountDAOImpl extends BaseDAO implements AccountDAO {

    private String statusStr  = "status";

    private String mediaIdStr = "mediaId";

    @Override
    public AccountDto selectById(Long mediaId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectById"), mediaId);
        } catch (Exception e) {
            logger.error("AccountDAO.selectById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public AccountDto selectByEmail(String email) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectByEmail"), email);
        } catch (Exception e) {
            logger.error("AccountDAO.selectByEmail happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateEmailStatus(Long mediaId, Integer status) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put(mediaIdStr, mediaId);
            param.put(statusStr, status);
            return getSqlSession().update(getStamentNameSpace("updateEmailStatus"), param);
        } catch (Exception e) {
            logger.error("AccountDAO.selectByEmail happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updatePasswdByEmail(String email, String password) throws TuiaMediaException {
        try {
            Map<String, Object> param = new HashMap<>(2);
            param.put("email", email);
            param.put("password", password);
            return getSqlSession().update(getStamentNameSpace("updatePasswdByEmail"), param);
        } catch (Exception e) {
            logger.error("AccountDaoImpl.updatePasswdByEmail happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int insert(AccountDto accountDto) throws TuiaMediaException {
        try {
            accountDto.setCheckStatus(AccountDto.CHECK_STATUS_ING);
            accountDto.setEmailStatus(AccountDto.EMAIL_STATUS_UNCHECK);
            accountDto.setFreezeStatus(AccountDto.UNFREEZED_STATUS);
            accountDto.setGmtCreate(new Date());
            accountDto.setGmtModified(accountDto.getGmtCreate());
            return getSqlSession().insert(getStamentNameSpace("insert"), accountDto);
        } catch (Exception e) {
            logger.error("AccountDaoImpl.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateAccount(ReqUpdateAccountBase req) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("updateAccount"), req);
        } catch (Exception e) {
            logger.error("AccountDaoImpl.updateAccount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateAuditData(AccountDto req) throws TuiaMediaException {
        try {
            req.setCheckStatus(AccountDto.CHECK_STATUS_ING);
            return getSqlSession().update(getStamentNameSpace("updateAuditData"), req);
        } catch (Exception e) {
            logger.error("AccountDaoImpl.updateAuditData happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public Integer selectMediaDataAmount(ReqGetAccountByPageDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectMediaDataAmount"), req);
        } catch (Exception e) {
            logger.error("MediaDAOImpl.selectMeidaDataAmount data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<AccountDto> selectMediaDataByPage(ReqGetAccountByPageDto req) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectMediaDataByPage"), req);
        } catch (Exception e) {
            logger.error("MediaDAOImpl.selectMediaDataByPage data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateCheckStatus(Long mediaId, Integer status) throws TuiaMediaException {
        try {
            Map<String, Object> paramMap = new HashMap<>(2);
            paramMap.put(mediaIdStr, mediaId);
            paramMap.put(statusStr, status);
            return getSqlSession().update(getStamentNameSpace("updateCheckStatus"), paramMap);
        } catch (Exception e) {
            logger.error("MediaDAOImpl.updateCheckStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateFreezeStatus(Long mediaId, Integer status) throws TuiaMediaException {
        try {
            Map<String, Object> paramMap = new HashMap<>(2);
            paramMap.put(mediaIdStr, mediaId);
            paramMap.put(statusStr, status);
            return getSqlSession().update(getStamentNameSpace("updateFreezeStatus"), paramMap);
        } catch (Exception e) {
            logger.error("MediaDAOImpl.updateFreezeStatus data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int updateEmail(Long mediaId, String email) throws TuiaMediaException {
        try {
            Map<String, Object> paramMap = new HashMap<>(2);
            paramMap.put(mediaIdStr, mediaId);
            paramMap.put("email", email);
            return getSqlSession().update(getStamentNameSpace("updateEmail"), paramMap);
        } catch (Exception e) {
            logger.error("MediaDAOImpl.updateEmail data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public AccountDto selectByPhone(String phone) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectByPhone"), phone);
        } catch (Exception e) {
            logger.error("AccountDAO.selectByPhone happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<IdAndName> selectMediaIdAndEmails(List<Long> mediaIds) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectMediaIdAndEmails"), mediaIds);
        } catch (Exception e) {
            logger.error("AccountDAO.selectEmails happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }

    }
}
